// LayerView.cpp : CLayerView NX̎
//

#include "stdafx.h"
#include "Layer.h"

#include "LayerDoc.h"
#include "LayerView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#include "MainFrm.h"
extern CMainFrame* g_pMainFrame;
#include "DlgOption.h"

// CLayerView

IMPLEMENT_DYNCREATE(CLayerView, CView)

BEGIN_MESSAGE_MAP(CLayerView, CView)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_MIYA, OnUpdateIndicatorMiya)
	ON_UPDATE_COMMAND_UI(ID_VIEW_COLOR, &CLayerView::OnUpdateViewColor)
	ON_COMMAND(ID_VIEW_COLOR, &CLayerView::OnViewColor)
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_COMMAND(ID_OPTION_OPTION, &CLayerView::OnOptionOption)
	ON_COMMAND(ID_CALC_CANDIDATE, &CLayerView::OnCalcCandidate)
	ON_COMMAND(ID_CALC_ITERCUT, &CLayerView::OnCalcItercut)
	ON_COMMAND(ID_VIEW_SHADING, &CLayerView::OnViewShading)
	ON_COMMAND(ID_VIEW_ALBEDO, &CLayerView::OnViewAlbedo)
	ON_COMMAND(ID_VIEW_ZENITH, &CLayerView::OnViewZenith)
	ON_COMMAND(ID_VIEW_AZIMUTH, &CLayerView::OnViewAzimuth)
	ON_COMMAND(ID_VIEW_NEEDLE, &CLayerView::OnViewNeedle)
	ON_COMMAND(ID_VIEW_RENDER, &CLayerView::OnViewRender)
	ON_COMMAND(ID_CALC_FIRSTCUT, &CLayerView::OnCalcFirstcut)
END_MESSAGE_MAP()

// CLayerView RXgNV/fXgNV

CLayerView::CLayerView()
{
	int i;

	// z̃TCYݒ
	PROCESSMAX = 100;
	WIDTH = 1024;
	HEIGHT = 768;
	IMAGEMIN = 3;
	IMAGEMAX = 8;
	COMBIMAX = COMBI3(IMAGEMAX);

	// vO}̃~X`FbN
	if(WIDTH % 4 != 0) AfxMessageBox("WIDTH4̔{ɂĂ");
	if(IMAGEMIN < 3) AfxMessageBox("IMAGEMIN3ȏɂĂ");
	if(IMAGEMIN > IMAGEMAX) AfxMessageBox("IMAGEMAXIMAGEMINȏɂĂ");

	// z̃m
	processdone = NULL;
	normal = NULL;
	albedo = NULL;
	normal0 = NULL;
	normal1 = NULL;
	albedo0 = NULL;
	albedo1 = NULL;
	xlst = NULL;
	ylst = NULL;
	zlst = NULL;
	rlst = NULL;
	glst = NULL;
	blst = NULL;
	lightpos = NULL;
	needleimage = NULL;
	renderimage = NULL;
	shadingimage = NULL;
	screendata = NULL;
	processdone = new bool[PROCESSMAX];
	normal = new float[WIDTH * HEIGHT * 3];
	albedo = new float[WIDTH * HEIGHT * 3];
	normal0 = new float[WIDTH * HEIGHT * 3];
	normal1 = new float[WIDTH * HEIGHT * 3];
	albedo0 = new float[WIDTH * HEIGHT * 3];
	albedo1 = new float[WIDTH * HEIGHT * 3];
	xlst = new float[WIDTH * HEIGHT * COMBIMAX];
	ylst = new float[WIDTH * HEIGHT * COMBIMAX];
	zlst = new float[WIDTH * HEIGHT * COMBIMAX];
	rlst = new float[WIDTH * HEIGHT * COMBIMAX];
	glst = new float[WIDTH * HEIGHT * COMBIMAX];
	blst = new float[WIDTH * HEIGHT * COMBIMAX];
	lightpos = new float*[IMAGEMAX];
	needleimage = new unsigned char[WIDTH * HEIGHT * 3];
	renderimage = new unsigned char[WIDTH * HEIGHT * 3];
	shadingimage = new MIYATYPE[IMAGEMAX * WIDTH * HEIGHT * 3];
	screendata = new unsigned char[4 * WIDTH * HEIGHT];
	if(processdone == NULL || normal == NULL || albedo == NULL || normal0 == NULL || normal1 == NULL || albedo0 == NULL || albedo1 == NULL
		|| xlst == NULL || ylst == NULL || zlst == NULL || rlst == NULL || glst == NULL || blst == NULL
		|| lightpos == NULL || needleimage == NULL || renderimage == NULL || shadingimage == NULL || screendata == NULL) {
		AfxMessageBox("܂");
		return;
	}
	for(i = 0; i < IMAGEMAX; i++) {
		lightpos[i] = NULL;
		lightpos[i] = new float[3];
		if(lightpos[i] == NULL) {
			AfxMessageBox("܂");
			return;
		}
	}
	graph = new GraphType(/*estimated # of nodes*/ WIDTH * HEIGHT,
		/*estimated # of edges*/ (WIDTH - 1) * HEIGHT + (HEIGHT - 1) * WIDTH); 

	// l
	EPS = 1.0e-15;
	INF = 1.0e+38;
	FLTINF = 1.0e+38f;
	INTINF = 0x7fffffff;
#ifdef MIYA_UCHAR
	TYPEMAX = (MIYATYPE)0xff;
#endif
#ifdef MIYA_USHORT
	TYPEMAX = (MIYATYPE)0xffff;
#endif
	UCHARMAX = (unsigned char)0xff;
	PI = 3.1415926535897932384626433832795;
	MENUVIEW = 1; // [\]j[j[Ŝ̉Ԗڂ̍ڂ
	COLR = 0;
	COLG = 1;
	COLB = 2;
	AXISX = 0;
	AXISY = 1;
	AXISZ = 2;
	MIYA_SHADING = 0;
	MIYA_ALBEDO = 1;
	MIYA_ZENITH = 2;
	MIYA_AZIMUTH = 3;
	MIYA_NEEDLE = 4;
	MIYA_RENDER = 5;
	MIYA_CANDIDATE = 30;
	maxmenu = 6;
	viewmode = 0;
	colormode = true;
	CheckView(0);
	imageview = 0;
	imagenum = 0;
	sFileName = "gcpsdata";

	// z
	for(i = 0; i < PROCESSMAX; i++) processdone[i] = false;
	for(i = 0; i < 4 * WIDTH * HEIGHT; i++) screendata[i] = 0;
}

CLayerView::~CLayerView()
{
}

BOOL CLayerView::PreCreateWindow(CREATESTRUCT& cs)
{
	return CView::PreCreateWindow(cs);
}

// CLayerView `

void CLayerView::OnDraw(CDC* pDC)
{
	CBitmap bitmap;
	CDC dcMemory;
	int w, h;

	if(processdone[viewmode] == false) return;

	// ̂̉摜\
	w = WIDTH;
	h = HEIGHT;
	if(w % 4 > 0){}//??
	bitmap.CreateCompatibleBitmap(pDC, w, h);
	bitmap.SetBitmapBits(w * h * 4, screendata);
	dcMemory.CreateCompatibleDC(pDC);
	dcMemory.SelectObject(&bitmap);
	pDC->BitBlt(0, 0, w, h, &dcMemory, 0, 0, SRCCOPY);
	bitmap.DeleteObject();
	dcMemory.DeleteDC();
}


// CLayerView ff

#ifdef _DEBUG
void CLayerView::AssertValid() const
{
	CView::AssertValid();
}

void CLayerView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CLayerDoc* CLayerView::GetDocument() const // fobOȊÕo[W̓CCłB
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CLayerDoc)));
	return (CLayerDoc*)m_pDocument;
}
#endif //_DEBUG


// CLayerView bZ[W nh

void CLayerView::CheckView(int miyamenu)
{
	g_pMainFrame->GetMenu()->GetSubMenu(MENUVIEW)->CheckMenuRadioItem(0, maxmenu - 1, miyamenu, MF_BYPOSITION);
}

void CLayerView::OnViewShading()
{
	viewmode = MIYA_SHADING;
	CheckView(viewmode);
	CreateImages();
	Invalidate();
}

void CLayerView::OnViewAlbedo()
{
	viewmode = MIYA_ALBEDO;
	CheckView(viewmode);
	CreateImages();
	Invalidate();
}

void CLayerView::OnViewZenith()
{
	viewmode = MIYA_ZENITH;
	CheckView(viewmode);
	CreateImages();
	Invalidate();
}

void CLayerView::OnViewAzimuth()
{
	viewmode = MIYA_AZIMUTH;
	CheckView(viewmode);
	CreateImages();
	Invalidate();
}

void CLayerView::OnViewNeedle()
{
	viewmode = MIYA_NEEDLE;
	CheckView(viewmode);
	CreateImages();
	Invalidate();
}

void CLayerView::OnViewRender()
{
	viewmode = MIYA_RENDER;
	CheckView(viewmode);
	CreateImages();
	Invalidate();
}

void CLayerView::OnUpdateViewColor(CCmdUI *pCmdUI)
{
	if(colormode) pCmdUI->SetCheck(1);
	else pCmdUI->SetCheck(0);
}

void CLayerView::OnViewColor()
{
	if(colormode) colormode = false;
	else colormode = true;
	CreateImages();
	Invalidate();
}

void CLayerView::OnOptionOption()
{
	DlgOption dlg;
	dlg.Width = WIDTH;
	dlg.Height = HEIGHT;
	if(dlg.DoModal() == IDOK)
	{
		AfxMessageBox("̋@\ɂ͂܂ΉĂ܂");
	}
}

void CLayerView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	if(nChar == VK_UP)
	{
		imageview--;
		if(imageview < 0) imageview = imagenum - 1;
	}
	if(nChar == VK_DOWN)
	{
		imageview++;
		if(imageview > imagenum - 1) imageview = 0;
	}

	CreateImages();
	Invalidate(FALSE);
	UpdateMiyaStatusbar();

	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CLayerView::UpdateMiyaStatusbar(void)
{
	CString s;
	s.Format("% 4d/% 4d", imageview + 1, imagenum);
	g_pMainFrame->m_wndStatusBar.SetPaneText(1, s, TRUE);
}

void CLayerView::OnUpdateIndicatorMiya(CCmdUI *pCmdUI)
{
	pCmdUI->Enable();
}

void CLayerView::OnInitialUpdate()
{
	CView::OnInitialUpdate();

	UpdateMiyaStatusbar();
}

// t@CJ
void CLayerView::OnFileOpen()
{
	POSITION pos;
	CFileDialog *cfd;
	CString sFileEach;
	CString sFilter;
	int numimg;
	int numlight;
	int numfile;
	const int maxfile = IMAGEMAX * 2;
	CString* sFileList;
	int inx;
	CString str;
	int* fileext;
	const int fileimg = 1;
	const int filelight = 2;
	int* fileid;
	char* ctemp;
	int i;
	int x, y;
	int c;
	int n;
	int j;
	bool* filereadimage;
	bool* filereadlight;
	int* indexlist;

	// ̊m
	sFileList = NULL;
	fileext = NULL;
	fileid = NULL;
	filereadimage = NULL;
	indexlist = NULL;
	ctemp = NULL;
	sFileList = new CString[maxfile];
	fileext = new int[maxfile];
	fileid = new int[maxfile];
	filereadimage = new bool[IMAGEMAX];
	filereadlight = new bool[IMAGEMAX];
	indexlist = new int[IMAGEMAX];
	ctemp = new char[2048 + 1];
	if(sFileList == 0 ||
		fileext == 0 ||
		fileid == 0 ||
		filereadimage == 0 ||
		filereadlight == 0 ||
		indexlist == 0 ||
		ctemp == 0)
	{
		AfxMessageBox("܂");
		return;
	}
	ctemp[0] = '\0';

	// 
	for(i = 0; i < IMAGEMAX; i++)
	{
		filereadimage[i] = false;
		filereadlight[i] = false;
		indexlist[i] = -1;
	}

	// t@CJ
#ifdef MIYA_UCHAR
	sFilter.Format("*.bmp;*.light.txt");
#endif
#ifdef MIYA_USHORT
	sFilter.Format("*.*.%d.%d.ushort.img.raw;*.*.light.lay", WIDTH, HEIGHT);
#endif
	cfd = new CFileDialog(true, NULL, NULL,
		OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_ALLOWMULTISELECT | OFN_EXPLORER | OFN_LONGNAMES,
		"ǂݍނׂt@C (" + sFilter + ")|" + sFilter + "|SẴt@C (*.*)|*.*||",
		AfxGetApp()->GetMainWnd());
	if(cfd == 0) return;
	cfd->m_ofn.lpstrTitle = "t@CƉ摜t@CJ܂";
	cfd->m_ofn.lpstrFile = ctemp;
	cfd->m_ofn.nMaxFile = 2048;
	numimg = 0;
	numlight = 0;
	numfile = 0;
	if(cfd->DoModal() == IDOK)
	{
		pos = cfd->GetStartPosition();
		while(pos != NULL)
		{
			// Y`FbN
			if(numfile > maxfile - 1) numfile = maxfile - 1;

			// t@C擾
			sFileEach = cfd->GetNextPathName(pos);
			sFileList[numfile] = sFileEach;

			// gqt@C̎ނo
			fileext[numfile] = 0;
			inx = sFileEach.ReverseFind('.');
			if(inx == -1) continue;
			if(sFileEach.Mid(inx) == ".lay" || sFileEach.Mid(inx) == ".txt")
			{
				str = sFileEach.Left(inx);
				inx = str.ReverseFind('.');
				if(inx == -1) continue;
				if(str.Mid(inx) == ".light")
				{
					numlight++;
					fileext[numfile] = filelight;
				}

				// t@C̔ԍo
				str = str.Left(inx);
				inx = str.ReverseFind('.');
				n = atoi(str.Mid(inx + 1));
				if(n < 0 || n >= IMAGEMAX) numimg = numlight = IMAGEMAX + 9999;
				fileid[numfile] = n;
			}
			if(sFileEach.Mid(inx) == ".raw")
			{
				str = sFileEach.Left(inx);
				inx = str.ReverseFind('.');
				if(inx == -1) continue;
				if(str.Mid(inx) == ".img")
				{
					str = str.Left(inx);
					inx = str.ReverseFind('.');
					if(inx == -1) continue;
					if(str.Mid(inx) == ".ushort")
					{
						str = str.Left(inx);
						inx = str.ReverseFind('.');
						n = atoi(str.Mid(inx + 1));
						if(n == HEIGHT)
						{
							str = str.Left(inx);
							inx = str.ReverseFind('.');
							n = atoi(str.Mid(inx + 1));
							if(n == WIDTH)
							{
								numimg++;
								fileext[numfile] = fileimg;
							}
						}
					}
				}

				// t@C̔ԍo
				str = str.Left(inx);
				inx = str.ReverseFind('.');
				n = atoi(str.Mid(inx + 1));
				if(n < 0 || n >= IMAGEMAX) numimg = numlight = IMAGEMAX + 9999;
				fileid[numfile] = n;
			}
			if(sFileEach.Mid(inx) == ".bmp")
			{
				numimg++;
				fileext[numfile] = fileimg;
				str = sFileEach;

				// t@C̔ԍo
				str = str.Left(inx);
				inx = str.ReverseFind('.');
				n = atoi(str.Mid(inx + 1));
				if(n < 0 || n >= IMAGEMAX) numimg = numlight = IMAGEMAX + 9999;
				fileid[numfile] = n;
			}

			// Y1₷
			numfile++;
		}
	}
	delete cfd;

	// t@Cǂݍ
	if(numimg >= IMAGEMIN &&
		numimg <= IMAGEMAX &&
		numlight >= IMAGEMIN &&
		numlight <= IMAGEMAX &&
		numimg == numlight)
	{
		// f[^
		for(i = 0; i < IMAGEMAX; i++)
		{
			// xECyCzOƂ
			lightpos[i][AXISX] = 0.0f;
			lightpos[i][AXISY] = 0.0f;
			lightpos[i][AXISZ] = 0.0f;
			for(x = 0; x < WIDTH; x++)
			{
				for(y = 0; y < HEIGHT; y++)
				{
					for(c = 0; c < 3; c++)
					{
						shadingimage[imgarry(i,x,y,c)] = 0;
					}
				}
			}
		}

		// t@Cǂݍ݃`FbN
		for(i = 0; i < numfile; i++)
		{
			if(fileext[i] == fileimg)
			{
				filereadimage[fileid[i]] = true;
			}
			if(fileext[i] == filelight)
			{
				filereadlight[fileid[i]] = true;
			}
		}

		// t@C̔ԍt
		inx = 0;
		imagenum = 0;
		for(i = 0; i < IMAGEMAX; i++)
		{
			if(filereadimage[i] && filereadlight[i])
			{
				indexlist[i] = inx;
				inx++;
				imagenum++;
			}
			else
			{
				indexlist[i] = -1;
			}
		}

		// t@Cǂݍ
		for(i = 0; i < numfile; i++)
		{
			inx = indexlist[fileid[i]];
			if(inx >= 0)
			{
				if(fileext[i] == fileimg) {
#ifdef MIYA_UCHAR
					ReadBmpImage(sFileList[i], inx);
#endif
#ifdef MIYA_USHORT
					ReadRawImage(sFileList[i], inx);
#endif
				}
				if(fileext[i] == filelight) ReadLight(sFileList[i], inx);
			}
		}

		// t@C𒊏o
		str = sFileName;
		for(i = 0; i < numfile; i++)
		{
			sFileEach = sFileList[i];
			inx = sFileEach.ReverseFind('\\');
			sFileEach = sFileEach.Mid(inx + 1);
			if(sFileEach == "") continue;
			if(i == 0)
			{
				sFileName = sFileEach;
				continue;
			}
			for(j = 0; j < sFileName.GetLength(); j++)
			{
				if(j >= sFileEach.GetLength()) break;
				if(sFileName[j] != sFileEach[j]) break;
			}
			sFileName = sFileName.Left(j);
		}
		if(sFileName == "") sFileName = str;
		else if(sFileName.Right(1) == ".") sFileName = sFileName.Left(sFileName.GetLength() - 1);

		// ㏈
		processdone[MIYA_SHADING] = true;
		CreateImages();
		Invalidate();
		UpdateMiyaStatusbar();
	}

	// 
	delete [] ctemp;
	delete [] sFileList;
	delete [] fileext;
	delete [] fileid;
	delete [] filereadimage;
	delete [] filereadlight;
	delete [] indexlist;
}

// RAWt@Cǂݍ
void CLayerView::ReadRawImage(CString filename, int id)
{
	CWaitCursor wait;
	int x, y;
	int c;
	CFile cf(filename, CFile::modeRead);
	CArchive ar(&cf, CArchive::load);

	// f[^ǂݍ
	for(y = 0; y < HEIGHT; y++)
	{
		for(x = 0; x < WIDTH; x++)
		{
			for(c = 0; c < 3; c++)
			{
				ar >> shadingimage[imgarry(id,x,y,c)];
			}
		}
	}

	ar.Close();
	cf.Close();
}

void CLayerView::ReadBmpImage(CString filename, int id)
{
	CWaitCursor wait;
	CFile cf(filename, CFile::modeRead);
	CArchive ar(&cf, CArchive::load);
	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER bmih;
	RGBQUAD rgbq[256];
	int i, j;
	unsigned char* ras;
	int x, y;
	int mx, my;
	unsigned int c;
	unsigned char cr, cg, cb;

	ar.Read((void*)&bmfh, 14);
	ar.Read((void*)&bmih, 40);
	if(bmfh.bfType != 0x4D42)
	{
		AfxMessageBox("Not a bitmap");
		return;
	}
	if(bmih.biWidth != WIDTH) {
		AfxMessageBox("Size different");
		return;
	}
	if(bmih.biHeight != HEIGHT) {
		AfxMessageBox("Size different");
		return;
	}
	switch(bmih.biBitCount)
	{
	case 1:
		i = 2;
		j = bmih.biWidth / 8;
		if(bmih.biWidth % 8 > 0) j++;
		j = ((j + 3) / 4) * 4;
		break;
	case 4:
		i = 16;
		j = bmih.biWidth / 2;
		if(bmih.biWidth % 2 > 0) j++;
		j = ((j + 3) / 4) * 4;
		break;
	case 8:
		i = 256;
		j = bmih.biWidth;
		j = ((j + 3) / 4) * 4;
		break;
	case 16:
		i = 0;
		j = bmih.biWidth * 2;
		j = ((j + 3) / 4) * 4;
		break;
	case 24:
		i = 0;
		j = bmih.biWidth * 3;
		j = ((j + 3) / 4) * 4;
		break;
	case 32:
		i = 0;
		j = bmih.biWidth * 4;
		break;
	}
	ar.Read((void*)rgbq, sizeof(RGBQUAD) * i);
	//ar.GetFile()->Seek(bmfh.bfOffBits, CFile::begin);
	ras = new unsigned char [j * bmih.biHeight];
	ar.Read(ras, j * bmih.biHeight);
	for(y = 0; y < bmih.biHeight; y++)
	{
		my = bmih.biHeight - 1 - y;
		for(x = 0; x < bmih.biWidth; x++)
		{
			switch(bmih.biBitCount)
			{
			case 1:
				mx = x / 8;
				i = my * j + mx;
				c = ras[i];
				i = 7 - x % 8;
				c = (c & (1 << i)) >> i;
				cb = rgbq[c].rgbBlue;
				cg = rgbq[c].rgbGreen;
				cr = rgbq[c].rgbRed;
				break;
			case 4:
				mx = x / 2;
				i = my * j + mx;
				c = ras[i];
				c = (x % 2 == 0) ? ((c & 0xF0) >> 4) : (c & 0x0F);
				cb = rgbq[c].rgbBlue;
				cg = rgbq[c].rgbGreen;
				cr = rgbq[c].rgbRed;
				break;
			case 8:
				mx = x;
				i = my * j + mx;
				c = ras[i];
				cb = rgbq[c].rgbBlue;
				cg = rgbq[c].rgbGreen;
				cr = rgbq[c].rgbRed;
				break;
			case 16:
				mx = x * 2;
				i = my * j + mx;
				c = ras[i] + (ras[i + 1] << 8);
				cb = (c & 0x001f) << 3;
				cg = ((c & 0x03e0) >> 5) << 3;
				cr = ((c & 0x7c00) >> 10) << 3;
				break;
			case 24:
				mx = x * 3;
				i = my * j + mx;
				cb = ras[i];
				cg = ras[i + 1];
				cr = ras[i + 2];
				break;
			case 32:
				mx = x * 4;
				i = my * j + mx;
				cb = ras[i];
				cg = ras[i + 1];
				cr = ras[i + 2];
				break;
			}
			shadingimage[imgarry(id,x,y,COLR)] = (MIYATYPE)cr;
			shadingimage[imgarry(id,x,y,COLG)] = (MIYATYPE)cg;
			shadingimage[imgarry(id,x,y,COLB)] = (MIYATYPE)cb;
		}
		if(bmih.biWidth % 4 > 0)
		{
			//ar.GetFile()->Seek(4 - bmih.biWidth % 4, CFile::current);
		}
	}
	delete ras;
	ar.Close();
	cf.Close();
}

// ʒut@Cǂݍ
void CLayerView::ReadLight(CString filename, int id)
{
	CWaitCursor wait;
	CString strData;
	CFile cf(filename, CFile::modeRead);
	CArchive ar(&cf, CArchive::load);
	int i;

	// f[^ǂݍ
	for(i = 0; i < 3; i++)
	{
		ar.ReadString(strData);
		lightpos[id][i] = (float)atof(strData);
	}

	ar.Close();
	cf.Close();
}

// t@Cۑ
void CLayerView::OnFileSaveAs()
{
	CWinApp* theApp = AfxGetApp();
	CFileDialog *cfd;
	CString s;
	int c;
	bool colormodebackup;
	int viewmodebackup;
	int imageviewbackup;
	CString sc;
	int i;

	colormodebackup = colormode;
	viewmodebackup = viewmode;
	imageviewbackup = imageview;

	for(c = 0; c < 2; c++)
	{
		if(c == 0)
		{
			colormode = true;
			sc = "color";
		}
		else
		{
			colormode = false;
			sc = "gray";
		}

		cfd = new CFileDialog(FALSE, "bmp", sFileName + "-albedo-" + sc + ".bmp",
			OFN_EXPLORER | OFN_HIDEREADONLY | OFN_LONGNAMES | OFN_NOREADONLYRETURN | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST,
			"摜t@C (*.bmp)|*.bmp|SẴt@C (*.*)|*.*||", theApp->GetMainWnd());
		cfd->m_ofn.lpstrTitle = "Axh摜t@Cۑ܂";
		if(cfd->DoModal() == IDOK)
		{
			viewmode = MIYA_ALBEDO;
			CreateImages();
			WriteImage(cfd->GetPathName());
		}
		delete cfd;

		cfd = new CFileDialog(FALSE, "bmp", sFileName + "-zenith-" + sc + ".bmp",
			OFN_EXPLORER | OFN_HIDEREADONLY | OFN_LONGNAMES | OFN_NOREADONLYRETURN | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST,
			"摜t@C (*.bmp)|*.bmp|SẴt@C (*.*)|*.*||", theApp->GetMainWnd());
		cfd->m_ofn.lpstrTitle = "VpƉ摜t@Cۑ܂";
		if(cfd->DoModal() == IDOK)
		{
			viewmode = MIYA_ZENITH;
			CreateImages();
			WriteImage(cfd->GetPathName());
		}
		delete cfd;

		cfd = new CFileDialog(FALSE, "bmp", sFileName + "-azimuth-" + sc + ".bmp",
			OFN_EXPLORER | OFN_HIDEREADONLY | OFN_LONGNAMES | OFN_NOREADONLYRETURN | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST,
			"摜t@C (*.bmp)|*.bmp|SẴt@C (*.*)|*.*||", theApp->GetMainWnd());
		cfd->m_ofn.lpstrTitle = "ʊpӉ摜t@Cۑ܂";
		if(cfd->DoModal() == IDOK)
		{
			viewmode = MIYA_AZIMUTH;
			CreateImages();
			WriteImage(cfd->GetPathName());
		}
		delete cfd;

		cfd = new CFileDialog(FALSE, "bmp", sFileName + "-needle-" + sc + ".bmp",
			OFN_EXPLORER | OFN_HIDEREADONLY | OFN_LONGNAMES | OFN_NOREADONLYRETURN | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST,
			"摜t@C (*.bmp)|*.bmp|SẴt@C (*.*)|*.*||", theApp->GetMainWnd());
		cfd->m_ofn.lpstrTitle = "j[h}bv摜t@Cۑ܂";
		if(cfd->DoModal() == IDOK)
		{
			viewmode = MIYA_NEEDLE;
			CreateImages();
			WriteImage(cfd->GetPathName());
		}
		delete cfd;
	}

	s = sFileName;
	s.AppendFormat(".%d.%d.normal.lay", WIDTH, HEIGHT);
	cfd = new CFileDialog(FALSE, "lay", s,
		OFN_EXPLORER | OFN_HIDEREADONLY | OFN_LONGNAMES | OFN_NOREADONLYRETURN | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST,
		"C[t@C (*.lay)|*.lay|SẴt@C (*.*)|*.*||", theApp->GetMainWnd());
	cfd->m_ofn.lpstrTitle = "@t@Cۑ܂";
	if(cfd->DoModal() == IDOK) WriteData(cfd->GetPathName(), MIYA_NEEDLE);
	delete cfd;

	colormode = true;
	viewmode = MIYA_RENDER;
	for(i = 0; i < imagenum; i++)
	{
		imageview = i;
		s = sFileName;
		s.AppendFormat("-render-%02d.bmp", i);
		cfd = new CFileDialog(FALSE, "bmp", s,
			OFN_EXPLORER | OFN_HIDEREADONLY | OFN_LONGNAMES | OFN_NOREADONLYRETURN | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST,
			"摜t@C (*.bmp)|*.bmp|SẴt@C (*.*)|*.*||", theApp->GetMainWnd());
		cfd->m_ofn.lpstrTitle = "_O摜t@Cۑ܂";
		if(cfd->DoModal() == IDOK)
		{
			CreateImages();
			WriteImage(cfd->GetPathName());
		}
		delete cfd;
	}

	colormode = colormodebackup;
	viewmode = viewmodebackup;
	imageview = imageviewbackup;
}

// BMPt@C
void CLayerView::WriteImage(CString filename)
{
	CWaitCursor wait;
	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER bmih;
	int i, j;
	unsigned char* ras;
	int x, y;
	int mx, my;
	unsigned char cr, cg, cb;
	int w, h;
	int k;
	CFile cf(filename, CFile::modeWrite | CFile::modeCreate);
	CArchive ar(&cf, CArchive::store);

	w = WIDTH;
	h = HEIGHT;

	bmfh.bfType = 0x4D42;
	bmfh.bfOffBits = 54;
	bmih.biSize = 40;
	bmih.biBitCount = 24;
	bmih.biWidth = w;
	bmih.biHeight = h;
	bmih.biPlanes = 1;
	bmih.biCompression = BI_RGB;
	bmih.biSizeImage = 0;
	bmih.biXPelsPerMeter = 0;
	bmih.biYPelsPerMeter = 0;
	bmih.biClrUsed = 0;
	bmih.biClrImportant = 0;
	j = w * 3;
	j = ((j + 3) / 4) * 4;
	ras = new unsigned char [j * h];
	for(i = 0; i < j * h; i++) ras[i] = 0;
	for(y = 0; y < h; y++)
	{
		my = h - 1 - y;
		for(x = 0; x < w; x++)
		{
			mx = x * 3;
			i = my * j + mx;
			if(w % 4 == 0) k = y * w * 4 + x * 4;
			else k = y * w * 4 + x * 4;//??
			cb = screendata[k + 0];
			cg = screendata[k + 1];
			cr = screendata[k + 2];
			ras[i + 0] = cb;
			ras[i + 1] = cg;
			ras[i + 2] = cr;;
		}
	}
	bmfh.bfSize = 54 + j * h;
	ar.Write((void*)&bmfh, 14);
	ar.Write((void*)&bmih, 40);
	ar.Write(ras, j * h);
	delete ras;

	ar.Close();
	cf.Close();
}

// f[^t@C
void CLayerView::WriteData(CString filename, int filemode)
{
	CWaitCursor wait;
	CFile cf(filename, CFile::modeWrite | CFile::modeCreate);
	CArchive ar(&cf, CArchive::store);
	int x, y;
	int c;

	// f[^
	for(y = 0; y < HEIGHT; y++)
	{
		for(x = 0; x < WIDTH; x++)
		{
			for(c = 0; c < 3; c++)
			{
				if(filemode == MIYA_NEEDLE) ar << normal[pixarry(x,y,c)];
			}
		}
	}

	ar.Close();
	cf.Close();
}

// 摜𐶐
void CLayerView::CreateImages(void)
{
	CWaitCursor wait;
	int x, y;
	int i;
	double p;
	int r, g, b;
	int m;

	// f[^`FbN
	if(!processdone[viewmode])
	{
		for(i = 0; i < 4 * WIDTH * HEIGHT; i++) screendata[i] = 0;
		return;
	}

	// 摜`
	if(viewmode == MIYA_NEEDLE) CreateNeedleImage(MIYA_NEEDLE);
	if(viewmode == MIYA_RENDER) CreateRenderImage();

	// 摜f[^쐬
	i = 0;
	for(y = 0; y < HEIGHT; y++)
	{
		for(x = 0; x < WIDTH; x++)
		{
			m = -1;
			if(viewmode == MIYA_SHADING)
			{
				r = (int)((unsigned int)shadingimage[imgarry(imageview,x,y,COLR)] * (unsigned int)UCHARMAX / (unsigned int)TYPEMAX);
				g = (int)((unsigned int)shadingimage[imgarry(imageview,x,y,COLG)] * (unsigned int)UCHARMAX / (unsigned int)TYPEMAX);
				b = (int)((unsigned int)shadingimage[imgarry(imageview,x,y,COLB)] * (unsigned int)UCHARMAX / (unsigned int)TYPEMAX);
				m = 2;
			}
			if(viewmode == MIYA_ALBEDO)
			{
				r = (int)floor(albedo[pixarry(x,y,COLR)] * (float)UCHARMAX / (float)TYPEMAX);
				g = (int)floor(albedo[pixarry(x,y,COLG)] * (float)UCHARMAX / (float)TYPEMAX);
				b = (int)floor(albedo[pixarry(x,y,COLB)] * (float)UCHARMAX / (float)TYPEMAX);
				m = 2;
			}
			if(viewmode == MIYA_ZENITH)
			{
				p = normal[pixarry(x,y,AXISZ)];
				if(p < 0.0) p = 0.0;
				if(p > 1.0) p = 1.0;
				p = acos(p);
				p = p / (PI / 2.0);
				m = 0;
			}
			if(viewmode == MIYA_AZIMUTH)
			{
				p = atan2(normal[pixarry(x,y,AXISY)], normal[pixarry(x,y,AXISX)]);
				if(p < 0.0) p += PI * 2.0;
				p = p / (PI * 2.0);
				m = 1;
			}
			if(viewmode == MIYA_NEEDLE)
			{
				r = (int)needleimage[pixarry(x,y,COLR)];
				g = (int)needleimage[pixarry(x,y,COLG)];
				b = (int)needleimage[pixarry(x,y,COLB)];
				m = 2;
			}
			if(viewmode == MIYA_RENDER)
			{
				r = (int)renderimage[pixarry(x,y,COLR)];
				g = (int)renderimage[pixarry(x,y,COLG)];
				b = (int)renderimage[pixarry(x,y,COLB)];
				m = 2;
			}

			if(m == 0)
			{
				if(colormode)
				{
					if(p < 0.2)
					{
						p = p * 5.0;
						r = 0;
						g = 0;
						b = (int)(p * 255.0);
					}
					else if(p < 0.4)
					{
						p = p - 0.2;
						p = p * 5.0;
						r = 0;
						g = (int)(p * 255.0);
						b = 255;
					}
					else if(p < 0.6)
					{
						p = p - 0.4;
						p = p * 5.0;
						r = 0;
						g = 255;
						b = (int)((1.0 - p) * 255.0);
					}
					else if(p < 0.8)
					{
						p = p - 0.6;
						p = p * 5.0;
						r = (int)(p * 255.0);
						g = 255;
						b = 0;
					}
					else
					{
						p = p - 0.8;
						p = p * 5.0;
						r = 255;
						g = (int)((1.0 - p) * 255.0);
						b = 0;
					}
				}
				else
				{
					r = g = b = (int)(p * 255.0);
				}
			}
			else if(m == 1)
			{
				if(colormode)
				{
					if(p < 1.0 / 6.0)
					{
						p = p * 6.0;
						r = 255;
						g = (int)(p * 255.0);
						b = 0;
					}
					else if(p < 2.0 / 6.0)
					{
						p = p - 1.0 / 6.0;
						p = p * 6.0;
						r = (int)((1.0 - p) * 255.0);
						g = 255;
						b = 0;
					}
					else if(p < 3.0 / 6.0)
					{
						p = p - 2.0 / 6.0;
						p = p * 6.0;
						r = 0;
						g = 255;
						b = (int)(p * 255.0);
					}
					else if(p < 4.0 / 6.0)
					{
						p = p - 3.0 / 6.0;
						p = p * 6.0;
						r = 0;
						g = (int)((1.0 - p) * 255.0);
						b = 255;
					}
					else if(p < 5.0 / 6.0)
					{
						p = p - 4.0 / 6.0;
						p = p * 6.0;
						r = (int)(p * 255.0);
						g = 0;
						b = 255;
					}
					else
					{
						p = p - 5.0 / 6.0;
						p = p * 6.0;
						r = 255;
						g = 0;
						b = (int)((1.0 - p) * 255.0);
					}
				}
				else
				{
					p = fabs(p - 0.5);
					p = p * 255.0;
					r = g = b = (int)p;
				}
			}
			else if(m == 2)
			{
				if(!colormode) r = g = b = (r + 2 * g + b) / 4;
			}
			else if(m == 3)
			{
				if(colormode)
				{
					if(p < 0.0)
					{
						r = (int)(-p * 255.0);
						g = 0;
						b = 0;
					}
					else
					{
						r = 0;
						g = (int)(p * 255.0);
						b = 0;
					}
				}
				else
				{
					r = g = b = (int)((p + 1.0) * 127.5);
				}
			}

			if(r > 255) r = 255;
			if(g > 255) g = 255;
			if(b > 255) b = 255;
			if(r < 0) r = 0;
			if(g < 0) g = 0;
			if(b < 0) b = 0;
			screendata[i] = b;
			i++;
			screendata[i] = g;
			i++;
			screendata[i] = r;
			i++;
			screendata[i] = 0;
			i++;
		}
		if(WIDTH % 4 > 0){}//??
	}
}

// j[h}bv`
void CLayerView::CreateNeedleImage(int filemode)
{
	CWaitCursor wait;
	const int NEEDLEBLOCKSIZE = 16; // 2ȏ̋, cTCY̖񐔂Ƃꂢ
	const int NEEDLELENGTH = 14;
	int x, y;
	int c;
	int xx, yy;
	int xe, ye;
	int s;
	double nx, ny;

	// 
	for(x = 0; x < WIDTH; x++)
	{
		for(y = 0; y < HEIGHT; y++)
		{
			for(c = 0; c < 3; c++)
			{
				needleimage[pixarry(x,y,c)] = 0;
			}
		}
	}

	// Sɓ_ł
	for(x = NEEDLEBLOCKSIZE / 2; x < WIDTH; x += NEEDLEBLOCKSIZE)
	{
		for(y = NEEDLEBLOCKSIZE / 2; y < HEIGHT; y += NEEDLEBLOCKSIZE)
		{
			for(xx = x - 1; xx <= x + 1; xx++)
			{
				for(yy = y - 1; yy <= y + 1; yy++)
				{
					for(c = 0; c < 3; c++)
					{
						needleimage[pixarry(xx,yy,c)] = 255;
					}
				}
			}
		}
	}

	// j[h`
	for(x = NEEDLEBLOCKSIZE / 2; x < WIDTH; x += NEEDLEBLOCKSIZE)
	{
		for(y = NEEDLEBLOCKSIZE / 2; y < HEIGHT; y += NEEDLEBLOCKSIZE)
		{
			if(filemode == MIYA_NEEDLE)
			{
				nx = normal[pixarry(x,y,AXISX)];
				ny = normal[pixarry(x,y,AXISY)];
			}
			xe = x + (int)floor((double)NEEDLELENGTH * nx);
			ye = y + (int)floor((double)NEEDLELENGTH * ny);
			for(s = 0; s <= NEEDLELENGTH; s++)
			{
				xx = (NEEDLELENGTH - s) * x + s * xe;
				xx = (int)floor((double)xx / (double)NEEDLELENGTH + 0.5);
				yy = (NEEDLELENGTH - s) * y + s * ye;
				yy = (int)floor((double)yy / (double)NEEDLELENGTH + 0.5);
				if(xx >= 0 && xx < WIDTH && yy >= 0 && yy < HEIGHT)
				{
					for(c = 0; c < 3; c++)
					{
						needleimage[pixarry(xx,yy,c)] = 255;
					}
				}
			}
		}
	}
}

// _O摜vZ
void CLayerView::CreateRenderImage()
{
	CWaitCursor wait;
	int x, y;
	int c;
	double s;
	int r;
	float lx, ly, lz;

	lx = lightpos[imageview][AXISX];
	ly = lightpos[imageview][AXISY];
	lz = lightpos[imageview][AXISZ];
	for(x = 0; x < WIDTH; x++)
	{
		for(y = 0; y < HEIGHT; y++)
		{
			s = DOTPRODUCT(lx, ly, lz, normal[pixarry(x,y,AXISX)], normal[pixarry(x,y,AXISY)], normal[pixarry(x,y,AXISZ)]);
			for(c = 0; c < 3; c++)
			{
				r = (int)floor(s * albedo[pixarry(x,y,c)] * (float)UCHARMAX / (float)TYPEMAX);
				if(r < 0) r = 0;
				if(r > 255) r = 255;
				renderimage[pixarry(x,y,c)] = (unsigned char)r;
			}
		}
	}
}

// sa[1..m][1..n]ْlA=UWV^T郋[`DsUaɏ㏑D
// ْl̑ΊpsW̓xNgw[1..n]ɓDsVi]uV^Tł͂Ȃjv[1..n][1..n]
// ɓDmnłȂ΂ȂȂDm<nȂC炩ả0΂̍s
// s(m=n)ɂĂ炱ĂяoD
void CLayerView::CalcSVD1(double **a, int m, int n, double w[], double **v)
{
	int flag, i, its, j, jj, k, l, nm;
	double anorm, c, f, g, h, s, scale, x, y, z, *rv1;

	rv1 = new double[n + 1];
	for(i = 1; i <= n; i++) rv1[i] = 0.0;
	g = scale = anorm = 0.0; // Householder@łQdΊp̌`ɒ
	for(i = 1; i <= n; i++)
	{
		l = i + 1;
		rv1[i] = scale * g;
		g = s = scale = 0.0;
		if(i <= m)
		{
			for(k = i; k <= m; k++) scale += fabs(a[k][i]);
			if(scale)
			{
				for(k = i; k <= m; k++)
				{
					a[k][i] /= scale;
					s += a[k][i] * a[k][i];
				}
				f = a[i][i];
				g = -SIGN(sqrt(s), f);
				h = f * g - s;
				a[i][i] = f - g;
				for(j = l; j <= n; j++)
				{
					for(s = 0.0, k = i; k <= m; k++) s += a[k][i] * a[k][j];
					f = s / h;
					for(k = i; k <= m; k++) a[k][j] += f * a[k][i];
				}
				for(k = i; k <= m; k++) a[k][i] *= scale;
			}
		}
		w[i] = scale * g;
		g = s = scale = 0.0;
		if(i <= m && i != n)
		{
			for(k = l; k <= n; k++) scale += fabs(a[i][k]);
			if(scale)
			{
				for(k = l; k <= n; k++)
				{
					a[i][k] /= scale;
					s += a[i][k] * a[i][k];
				}
				f = a[i][l];
				g = -SIGN(sqrt(s), f);
				h = f * g - s;
				a[i][l] = f - g;
				for(k = l; k <= n; k++) rv1[k] = a[i][k] / h;
				for(j = l; j <= m; j++)
				{
					for(s = 0.0, k = l; k <= n; k++) s += a[j][k] * a[i][k];
					for(k = l; k <= n; k++) a[j][k] += s * rv1[k];
				}
				for(k = l; k <= n; k++) a[i][k] *= scale;
			}
		}
		anorm = FMAX(anorm, fabs(w[i]) + fabs(rv1[i]));
	}
	for(i = n; i >= 1; i--) // E̕ϊ̗ݐ
	{
		if(i < n)
		{
			if(g)
			{
				for(j = l; j <= n; j++) v[j][i] = (a[i][j] / a[i][l]) / g; // A_[t[邽߁CQx肷
				for(j = l; j <= n; j++)
				{
					for(s = 0.0, k = l; k <= n; k++) s += a[i][k] * v[k][j];
					for(k = l; k <= n; k++) v[k][j] += s * v[k][i];
				}
			}
			for(j = l; j <= n; j++) v[i][j] = v[j][i] = 0.0;
		}
		v[i][i] = 1.0;
		g = rv1[i];
		l = i;
	}
	for(i = IMIN(m, n); i >= 1; i--) // ̕ϊ̗ݐ
	{
		l = i + 1;
		g = w[i];
		for(j = l; j <= n; j++) a[i][j] = 0.0;
		if(g)
		{
			g = 1.0 / g;
			for(j = l; j <= n; j++)
			{
				for(s = 0.0, k = l; k <= m; k++) s += a[k][i] * a[k][j];
				f = (s / a[i][i]) * g;
				for(k = i; k <= m; k++) a[k][j] += f * a[k][i];
			}
			for(j = i; j <= m; j++) a[j][i] *= g;
		}
		else
		{
			for(j = i; j <= m; j++) a[j][i] = 0.0;
		}
		++a[i][i];
	}
	for(k = n; k >= 1; k--) // QdΊps̑ΊpFْlɂẴ[vƁCvZ̃[v
	{
		for(its = 1; its <= 30; its++)
		{
			flag = 1;
			for(l = k; l >= 1; l--) // ̃`FbN
			{
				nm = l - 1; // rv1[1]͏0
				if(fabs(rv1[l]) < EPS)
				{
					flag = 0;
					break;
				}
				if(fabs(w[nm]) < EPS) break;
			}
			if(flag)
			{
				c = 0.0; // l>1̂Ƃrv1[l]
				s = 1.0;
				for(i = l; i <= k; i++)
				{
					f = s * rv1[i];
					rv1[i] = c * rv1[i];
					if(fabs(f) < EPS) break;
					g = w[i];
					h = pythag(f, g);
					w[i] = h;
					h = 1.0 / h;
					c = g * h;
					s = -f * h;
					for(j = 1; j <= m; j++)
					{
						y = a[j][nm];
						z = a[j][i];
						a[j][nm] = y * c + z * s;
						a[j][i] = z * c - y * s;
					}
				}
			}
			z = w[k];
			if(l == k) // 
			{
				if(z < 0.0) // ْl񕉂ɂ
				{
					w[k] = -z;
					for(j = 1; j <= n; j++) v[j][k] = -v[j][k];
				}
				break;
			}
			if(its == 30) AfxMessageBox("no convergence in 30 svdcmp iterations"); // 30JԂĂȂ
			x = w[l]; // ŉ̂QsQ̏s񎮂̃Vtg
			nm = k - 1;
			y = w[nm];
			g = rv1[nm];
			h = rv1[k];
			f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
			g = pythag(f, 1.0);
			f = ((x - z) * (x + z) + h * ((y / (f + SIGN(g, f))) - h)) / x;
			c = s = 1.0; // QRϊ
			for(j = l; j <= nm; j++)
			{
				i = j + 1;
				g = rv1[i];
				y = w[i];
				h = s * g;
				g = c * g;
				z = pythag(f, h);
				rv1[j] = z;
				c = f / z;
				s = h / z;
				f = x * c + g * s;
				g = g * c - x * s;
				h = y * s;
				y *= c;
				for(jj = 1; jj <= n; jj++)
				{
					x = v[jj][j];
					z = v[jj][i];
					v[jj][j] = x * c + z * s;
					v[jj][i] = z * c - x * s;
				}
				z = pythag(f, h);
				w[j] = z; // z = 0Ȃ]͔C
				if(z)
				{
					z = 1.0 / z;
					c = f * z;
					s = h * z;
				}
				f = c * g + s * y;
				x = c * y - s * g;
				for(jj = 1; jj <= m; jj++)
				{
					y = a[jj][j];
					z = a[jj][i];
					a[jj][j] = y * c + z * s;
					a[jj][i] = z * c - y * s;
				}
			}
			rv1[l] = 0.0;
			rv1[k] = f;
			w[k] = x;
		}
	}
	delete [] rv1;
}

// sqrt(a^2 + b^2)vZDA_[t[I[o[t[ȂD
double CLayerView::pythag(double a, double b)
{
	double absa, absb;
	absa = fabs(a);
	absb = fabs(b);
	if(absa > absb) return absa * sqrt(1.0 + SQR(absb / absa));
	else return (absb == 0.0 ? 0.0 : absb * sqrt(1.0 + SQR(absa / absb)));
}

// sa[0..m-1][0..n-1]ْlA=UWV^T郋[`DsUaɏ㏑D
// ْl̑ΊpsW̓xNgw[0..n-1]ɓDsVi]uV^Tł͂Ȃjv[0..n-1][0..n-1]
// ɓDmnłȂ΂ȂȂDm<nȂC炩ả0΂̍s
// s(m=n)ɂĂ炱ĂяoD
void CLayerView::CalcSVD0(double** a, int m, int n, double w[], double** v)
{
	double** nrcu;
	double** nrcv;
	int i;

	try
	{
		nrcu = new double*[m];
		nrcv = new double*[n];
	}
	catch(...)
	{
		return;
	}
	for(i = 0; i < m; i++) nrcu[i] = a[i] - 1;
	for(i = 0; i < n; i++) nrcv[i] = v[i] - 1;
	CalcSVD1(nrcu - 1, m, n, w - 1, nrcv - 1); // Numerical Recipes̃[`͓Y1n܂
	delete [] nrcv;
	delete [] nrcu;
}

// Ax=bꍇ̋[tsvZ
// Fwd́CInvCFwd͉
void CLayerView::CalcPseudoInverse(double** Fwd, double** Inv, int row, int col)
{
	int i, j, k;
	double* w;
	double** v;

	// m
	w = NULL;
	v = NULL;
	w = new double[col];
	v = new double*[col];
	if(w == NULL || v == NULL) {
		AfxMessageBox("܂");
		return;
	}
	for(i = 0; i < col; i++) {
		v[i] = NULL;
		v[i] = new double[col];
		if(v[i] == NULL) {
			AfxMessageBox("܂");
			return;
		}
	}

	// ْl
	CalcSVD0(Fwd, row, col, w, v);

	// W̋tsvZ
	for(i = 0; i < col; i++) {
		if(w[i] < EPS) w[i] = 0.0;
		else w[i] = 1.0 / w[i];
	}

	// W^-1 * U^T vZ
	for(i = 0; i < col; i++) {
		for(j = 0; j < row; j++) {
			Fwd[j][i] *= w[i];
		}
	}

	// ɍV
	for(i = 0; i < col; i++) {
		for(j = 0; j < row; j++) {
			Inv[i][j] = 0.0;
			for(k = 0; k < col; k++) {
				Inv[i][j] += v[i][k] * Fwd[j][k];
			}
		}
	}

	// 
	for(i = 0; i < col; i++) {
		delete [] v[i];
	}
	delete [] v;
	delete [] w;
}

// @ƃAxȟvZClI
void CLayerView::OnCalcCandidate()
{
	CWaitCursor wait;
	int x, y;
	double** Lfwd;
	double** Linv;
	int i;
	int c;
	double r;
	int img0, img1, img2;
	int j;
	double detL;
	double nxsum, nysum, nzsum;
	double shade0, shade1, shade2;
	double w;
	double nx, ny, nz;
	int* img0list;
	int* img1list;
	int* img2list;
	int* ilist;
	int k;
	int num;
	CTime ctStart;
	CTime ctEnd;
	CTimeSpan ctInterval;
	DWORD tickStart;
	DWORD tickEnd;
	DWORD tickInterval;
	CString str;
	const double SHADINGMIN = 0.01;
	double shadingval;
	double r0, g0, b0;
	double r1, g1, b1;
	double r2, g2, b2;
	const double NORMALMIN = 0.01;
	const double ALBEDOMIN = 1.0;
	const double ALBEDOMAX = 65535.0;
	double rval, gval, bval;
	const int COMBINUM = COMBI3(imagenum);

	// `FbN
	if(!processdone[MIYA_SHADING]) return;

	// m
	Lfwd = NULL;
	Linv = NULL;
	img0list = NULL;
	img1list = NULL;
	img2list = NULL;
	ilist = NULL;
	Lfwd = new double*[3];
	Linv = new double*[3];
	img0list = new int[COMBINUM];
	img1list = new int[COMBINUM];
	img2list = new int[COMBINUM];
	ilist = new int[imagenum];
	if(Lfwd == NULL || Linv == NULL || img0list == NULL || img1list == NULL || img2list == NULL || ilist == NULL) {
		AfxMessageBox("܂");
		return;
	}
	for(i = 0; i < 3; i++) {
		Lfwd[i] = NULL;
		Lfwd[i] = new double[3];
		if(Lfwd[i] == NULL) {
			AfxMessageBox("܂");
			return;
		}
	}
	for(i = 0; i < 3; i++) {
		Linv[i] = NULL;
		Linv[i] = new double[3];
		if(Linv[i] == NULL) {
			AfxMessageBox("܂");
			return;
		}
	}

	// Jnݒ
	ctStart = CTime::GetCurrentTime();
	tickStart = ::GetTickCount();

	// gݍ킹vZiIԌ̐͂RŌŒjiint^32bit̏ꍇC摜̖32ȂƂȂj
	k = 0;
	for(i = 0; i < (1 << imagenum); i++)
	{
		num = 0;
		for(j = 0; j < imagenum; j++) ilist[j] = -1;
		for(j = 0; j < imagenum; j++)
		{
			if(i & (1 << j))
			{
				ilist[num] = j;
				num++;
			}
		}
		if(num == 3)
		{
			img0list[k] = ilist[0];
			img1list[k] = ilist[1];
			img2list[k] = ilist[2];
			k++;
		}
	}
	if(k != COMBINUM)
	{
		AfxMessageBox("vOɃoO܂");
		return;
	}

	// @̌炩ߌvZ
	for(x = 0; x < WIDTH; x++)
	{
		for(y = 0; y < HEIGHT; y++)
		{
			// SĂ̑gݍ킹ŋ߂@Xgɒǉ
			for(k = 0; k < COMBINUM; k++)
			{
				// I΂ꂽR̌̔ԍ
				img0 = img0list[k];
				img1 = img1list[k];
				img2 = img2list[k];

				// s쐬isj(img:,j:X,Y,Z)
				for(j = 0; j < 3; j++)
				{
					Lfwd[0][j] = lightpos[img0][j];
					Lfwd[1][j] = lightpos[img1][j];
					Lfwd[2][j] = lightpos[img2][j];
				}

				// tsvZ
				detL =
					Lfwd[0][0] * Lfwd[1][1] * Lfwd[2][2] +
					Lfwd[1][0] * Lfwd[2][1] * Lfwd[0][2] +
					Lfwd[2][0] * Lfwd[0][1] * Lfwd[1][2] -
					Lfwd[0][0] * Lfwd[2][1] * Lfwd[1][2] -
					Lfwd[2][0] * Lfwd[1][1] * Lfwd[0][2] -
					Lfwd[1][0] * Lfwd[0][1] * Lfwd[2][2];
				if(fabs(detL) < EPS)
				{
					nx = 2.0 * (double)rand() / (double)RAND_MAX - 1.0;
					ny = 2.0 * (double)rand() / (double)RAND_MAX - 1.0;
					nz = 1.0 * (double)rand() / (double)RAND_MAX;
				} else {
					Linv[0][0] = Lfwd[1][1] * Lfwd[2][2] - Lfwd[1][2] * Lfwd[2][1];
					Linv[0][1] = Lfwd[0][2] * Lfwd[2][1] - Lfwd[0][1] * Lfwd[2][2];
					Linv[0][2] = Lfwd[0][1] * Lfwd[1][2] - Lfwd[0][2] * Lfwd[1][1];
					Linv[1][0] = Lfwd[1][2] * Lfwd[2][0] - Lfwd[1][0] * Lfwd[2][2];
					Linv[1][1] = Lfwd[0][0] * Lfwd[2][2] - Lfwd[0][2] * Lfwd[2][0];
					Linv[1][2] = Lfwd[0][2] * Lfwd[1][0] - Lfwd[0][0] * Lfwd[1][2];
					Linv[2][0] = Lfwd[1][0] * Lfwd[2][1] - Lfwd[1][1] * Lfwd[2][0];
					Linv[2][1] = Lfwd[0][1] * Lfwd[2][0] - Lfwd[0][0] * Lfwd[2][1];
					Linv[2][2] = Lfwd[0][0] * Lfwd[1][1] - Lfwd[0][1] * Lfwd[1][0];
					for(i = 0; i < 3; i++)
					{
						for(j = 0; j < 3; j++)
						{
							Linv[i][j] /= detL;
						}
					}

					// @vZ
					nxsum = 0.0;
					nysum = 0.0;
					nzsum = 0.0;
					for(c = 0; c < 3; c++)
					{
						// Px̖O̕tւ
						shade0 = (double)shadingimage[imgarry(img0,x,y,c)];
						shade1 = (double)shadingimage[imgarry(img1,x,y,c)];
						shade2 = (double)shadingimage[imgarry(img2,x,y,c)];

						// d݂vZ
						w = SQR((shade0 + shade1 + shade2) / 3.0);

						// @vZ
						nx = Linv[0][0] * shade0 + Linv[0][1] * shade1 + Linv[0][2] * shade2;
						ny = Linv[1][0] * shade0 + Linv[1][1] * shade1 + Linv[1][2] * shade2;
						nz = Linv[2][0] * shade0 + Linv[2][1] * shade1 + Linv[2][2] * shade2;
						r = NORM(nx, ny, nz);
						if(r > EPS)
						{
							nxsum += w * nx / r;
							nysum += w * ny / r;
							nzsum += w * nz / r;
						}
					}
					r = NORM(nxsum, nysum, nzsum);
					if(r > EPS)
					{
						// @𐳋K
						nx = nxsum / r;
						ny = nysum / r;
						nz = nzsum / r;
					}
					else
					{
						nx = 2.0 * (double)rand() / (double)RAND_MAX - 1.0;
						ny = 2.0 * (double)rand() / (double)RAND_MAX - 1.0;
						nz = 1.0 * (double)rand() / (double)RAND_MAX;
					}
					if(nz < NORMALMIN)
					{
						nz = NORMALMIN;
						r = NORM(nx, ny, nz);
						nx /= r;
						ny /= r;
						nz /= r;
					}
				}

				// @Xgɒǉ
				xlst[lstarry(x,y,k)] = (float)nx;
				ylst[lstarry(x,y,k)] = (float)ny;
				zlst[lstarry(x,y,k)] = (float)nz;

				// Axh0
				shadingval = DOTPRODUCT(lightpos[img0][AXISX], lightpos[img0][AXISY], lightpos[img0][AXISZ], nx, ny, nz);
				if(shadingval > SHADINGMIN)
				{
					r0 = (double)shadingimage[imgarry(img0,x,y,COLR)] / shadingval;
					g0 = (double)shadingimage[imgarry(img0,x,y,COLG)] / shadingval;
					b0 = (double)shadingimage[imgarry(img0,x,y,COLB)] / shadingval;
				}
				else
				{
					r0 = g0 = b0 = 255.0 * (double)rand() / (double)RAND_MAX;
				}

				// Axh1
				shadingval = DOTPRODUCT(lightpos[img1][AXISX], lightpos[img1][AXISY], lightpos[img1][AXISZ], nx, ny, nz);
				if(shadingval > SHADINGMIN)
				{
					r1 = (double)shadingimage[imgarry(img1,x,y,COLR)] / shadingval;
					g1 = (double)shadingimage[imgarry(img1,x,y,COLG)] / shadingval;
					b1 = (double)shadingimage[imgarry(img1,x,y,COLB)] / shadingval;
				}
				else
				{
					r1 = g1 = b1 = 255.0 * (double)rand() / (double)RAND_MAX;
				}

				// Axh2
				shadingval = DOTPRODUCT(lightpos[img2][AXISX], lightpos[img2][AXISY], lightpos[img2][AXISZ], nx, ny, nz);
				if(shadingval > SHADINGMIN)
				{
					r2 = (double)shadingimage[imgarry(img2,x,y,COLR)] / shadingval;
					g2 = (double)shadingimage[imgarry(img2,x,y,COLG)] / shadingval;
					b2 = (double)shadingimage[imgarry(img2,x,y,COLB)] / shadingval;
				}
				else
				{
					r2 = g2 = b2 = 255.0 * (double)rand() / (double)RAND_MAX;
				}

				// AxhXgɒǉ
				rval = (r0 + r1 + r2) / 3.0;
				gval = (g0 + g1 + g2) / 3.0;
				bval = (b0 + b1 + b2) / 3.0;
				if(rval < ALBEDOMIN) rval = ALBEDOMIN;
				if(gval < ALBEDOMIN) gval = ALBEDOMIN;
				if(bval < ALBEDOMIN) bval = ALBEDOMIN;
				if(rval > ALBEDOMAX) rval = ALBEDOMAX;
				if(gval > ALBEDOMAX) gval = ALBEDOMAX;
				if(bval > ALBEDOMAX) bval = ALBEDOMAX;
				rlst[lstarry(x,y,k)] = (float)rval;
				glst[lstarry(x,y,k)] = (float)gval;
				blst[lstarry(x,y,k)] = (float)bval;
			}
		}
	}

	// Iݒ
	ctEnd = CTime::GetCurrentTime();
	tickEnd = ::GetTickCount();

	// 
	for(i = 0; i < 3; i++) {
		delete [] Lfwd[i];
	}
	for(i = 0; i < 3; i++)
	{
		delete [] Linv[i];
	}
	delete [] Lfwd;
	delete [] Linv;
	delete [] img0list;
	delete [] img1list;
	delete [] img2list;
	delete [] ilist;

	// ㏈
	processdone[MIYA_CANDIDATE] = true;
	CreateImages();
	Invalidate();

	// IbZ[W
	str = "vZI܂\n";
	str += "\n";
	str += "Jn: " + ctStart.Format("%Y/%m/%d %H:%M:%S") + "\n";
	str += "I: " + ctEnd.Format("%Y/%m/%d %H:%M:%S") + "\n";
	ctInterval = ctEnd - ctStart;
	str += "vZ: " + ctInterval.Format("%H:%M:%S") + "\n";
	tickInterval = tickEnd - tickStart;
	str.AppendFormat("vZ: %dm~bn\n",  tickInterval);
	AfxMessageBox(str);
}

// lvZ
void CLayerView::OnCalcFirstcut()
{
	CWaitCursor wait;
	int x, y;
	double nx, ny, nz;
	int k;
	CString str;
	double rval, gval, bval;
	const int COMBINUM = COMBI3(imagenum);

	// `FbN
	if(!processdone[MIYA_CANDIDATE]) return;

	// OtJbg̏
	flowcostneedle = INF;
	flowcostalbedo = INF;
	wholeiterationnumber = 0;

	// _őI񂾌lƂ
	for(x = 0; x < WIDTH; x++)
	{
		for(y = 0; y < HEIGHT; y++)
		{
			k = rand() % COMBINUM;
			nx = xlst[lstarry(x,y,k)];
			ny = ylst[lstarry(x,y,k)];
			nz = zlst[lstarry(x,y,k)];
			normal[pixarry(x,y,AXISX)] = (float)nx;
			normal[pixarry(x,y,AXISY)] = (float)ny;
			normal[pixarry(x,y,AXISZ)] = (float)nz;

			k = rand() % COMBINUM;
			rval = rlst[lstarry(x,y,k)];
			gval = glst[lstarry(x,y,k)];
			bval = blst[lstarry(x,y,k)];
			albedo[pixarry(x,y,COLR)] = (float)rval;
			albedo[pixarry(x,y,COLG)] = (float)gval;
			albedo[pixarry(x,y,COLB)] = (float)bval;
		}
	}

	// ㏈
	processdone[MIYA_ALBEDO] = true;
	processdone[MIYA_ZENITH] = true;
	processdone[MIYA_AZIMUTH] = true;
	processdone[MIYA_NEEDLE] = true;
	processdone[MIYA_RENDER] = true;
	viewmode = MIYA_ALBEDO;
	CheckView(viewmode);
	CreateImages();
	Invalidate();

	// IbZ[W
	str = "܂\n";
	AfxMessageBox(str);
}

// vZŃOtJbgvZ
void CLayerView::OnCalcItercut()
{
	CWaitCursor wait;
	int x, y;
	CTime ctStart;
	CTime ctEnd;
	CTimeSpan ctInterval;
	DWORD tickStart;
	DWORD tickEnd;
	DWORD tickInterval;
	CString str;
	float LAMBDAA = 1.0f;
	float LAMBDAN = 0.1f;
	const int combinum = COMBI3(imagenum);
	int k;
	double prevcostneedle, prevcostalbedo;
	bool isconverge;

	// `FbN
	if(!processdone[MIYA_ALBEDO]) return;

	// Jnݒ
	ctStart = CTime::GetCurrentTime();
	tickStart = ::GetTickCount();

	// SĂ̌Ń[v
	prevcostneedle = flowcostneedle;
	prevcostalbedo = flowcostalbedo;
	if(wholeiterationnumber == 0) {
		LAMBDAA = 0.0f;
		LAMBDAN = 0.0f;
	}
	for(k = 0; k < combinum; k++) {
		// 0ƌ1I
		for(y = 0; y < HEIGHT; y++)
		{
			for(x = 0; x < WIDTH; x++)
			{
				// 0݂̖͌@Ƃ
				normal0[pixarry(x,y,AXISX)] = normal[pixarry(x,y,AXISX)];
				normal0[pixarry(x,y,AXISY)] = normal[pixarry(x,y,AXISY)];
				normal0[pixarry(x,y,AXISZ)] = normal[pixarry(x,y,AXISZ)];

				// 1͌⃊XgI
				normal1[pixarry(x,y,AXISX)] = xlst[lstarry(x,y,k)];
				normal1[pixarry(x,y,AXISY)] = ylst[lstarry(x,y,k)];
				normal1[pixarry(x,y,AXISZ)] = zlst[lstarry(x,y,k)];
			}
		}

		// OtJbg
		SolveGraphCut(MIYA_NEEDLE, LAMBDAN);

		// 0ƌ1I
		for(y = 0; y < HEIGHT; y++)
		{
			for(x = 0; x < WIDTH; x++)
			{
				// 0݂͌̃AxhƂ
				albedo0[pixarry(x,y,COLR)] = albedo[pixarry(x,y,COLR)];
				albedo0[pixarry(x,y,COLG)] = albedo[pixarry(x,y,COLG)];
				albedo0[pixarry(x,y,COLB)] = albedo[pixarry(x,y,COLB)];

				// 1͌⃊XgI
				albedo1[pixarry(x,y,COLR)] = rlst[lstarry(x,y,k)];
				albedo1[pixarry(x,y,COLG)] = glst[lstarry(x,y,k)];
				albedo1[pixarry(x,y,COLB)] = blst[lstarry(x,y,k)];
			}
		}

		// OtJbg
		SolveGraphCut(MIYA_ALBEDO, LAMBDAA);
	}
	if(flowcostneedle < prevcostneedle || flowcostalbedo < prevcostalbedo) isconverge = false;
	else isconverge = true;
	if(wholeiterationnumber == 0) {
		flowcostneedle = INF;
		flowcostalbedo = INF;
	}
	wholeiterationnumber++;

	// ㏈
	processdone[MIYA_ALBEDO] = true;
	processdone[MIYA_ZENITH] = true;
	processdone[MIYA_AZIMUTH] = true;
	processdone[MIYA_NEEDLE] = true;
	processdone[MIYA_RENDER] = true;
	CreateImages();
	Invalidate();

	// IbZ[W
	ctEnd = CTime::GetCurrentTime();
	ctInterval = ctEnd - ctStart;
	tickEnd = ::GetTickCount();
	tickInterval = tickEnd - tickStart;
	str = "vZI܂\n";
	str += "\n";
	str += "Jn: " + ctStart.Format("%Y/%m/%d %H:%M:%S") + "\n";
	str += "I: " + ctEnd.Format("%Y/%m/%d %H:%M:%S") + "\n";
	str += "oߎ: " + ctInterval.Format("%H:%M:%S") + "\n";
	str.AppendFormat("oߎ: %dm~bn\n",  tickInterval);
	str.AppendFormat("@̃RXg: %1.15f\n", flowcostneedle);
	str.AppendFormat("Axh̃RXg: %1.15f\n", flowcostalbedo);
	str.AppendFormat(": %d\n", wholeiterationnumber);
	if(isconverge) str += "܂\n";
	else str += "܂Ă܂\n";
	AfxMessageBox(str);
}

// OtJbgvZ
// m[h̐ W*H
// GbW̐ (W-1)*H + (H-1)*W
// m[hԍ i = Y*W + X
// \[XɌ0̃RXgCVNɌ1̃RXgt
void CLayerView::SolveGraphCut(int mode, float LAMBDA)
{
	int x, y;
	int i;
	float cost00, cost11, cost01, cost10;
	float costval;
	double shadingval;
	int j;
	float cost0, cost1;
	int px, py, qx, qy;
	double nx, ny, nz;
	double ar, ag, ab;
	double p00, p01, p02;
	double p10, p11, p12;
	double q00, q01, q02;
	double q10, q11, q12;
	double p0, p1, p2;
	double q0, q1, q2;
	double flowcost;
	double prevcost;

	// OtJbǧvZ
	graph->reset();
	graph->add_node(HEIGHT * WIDTH);
	for(y = 0; y < HEIGHT; y++)
	{
		for(x = 0; x < WIDTH; x++)
		{
			i = y * WIDTH + x;

			// 0̃RXg
			cost0 = 0.0f;
			for(j = 0; j < imagenum; j++)
			{
				if(mode == MIYA_NEEDLE) {
					nx = normal0[pixarry(x,y,AXISX)];
					ny = normal0[pixarry(x,y,AXISY)];
					nz = normal0[pixarry(x,y,AXISZ)];
					ar = albedo[pixarry(x,y,COLR)];
					ag = albedo[pixarry(x,y,COLG)];
					ab = albedo[pixarry(x,y,COLB)];
				} else {
					nx = normal[pixarry(x,y,AXISX)];
					ny = normal[pixarry(x,y,AXISY)];
					nz = normal[pixarry(x,y,AXISZ)];
					ar = albedo0[pixarry(x,y,COLR)];
					ag = albedo0[pixarry(x,y,COLG)];
					ab = albedo0[pixarry(x,y,COLB)];
				}
				shadingval = DOTPRODUCT(lightpos[j][AXISX], lightpos[j][AXISY], lightpos[j][AXISZ], nx, ny, nz);
				cost0 += (float)LORENTZ(NORM((double)shadingimage[imgarry(j,x,y,COLR)] - shadingval * ar,
					(double)shadingimage[imgarry(j,x,y,COLG)] - shadingval * ag,
					(double)shadingimage[imgarry(j,x,y,COLB)] - shadingval * ab));
			}
			cost0 /= (float)imagenum;
			cost0 *= LAMBDA;

			// 1̃RXg
			cost1 = 0.0f;
			for(j = 0; j < imagenum; j++)
			{
				if(mode == MIYA_NEEDLE) {
					nx = normal1[pixarry(x,y,AXISX)];
					ny = normal1[pixarry(x,y,AXISY)];
					nz = normal1[pixarry(x,y,AXISZ)];
					ar = albedo[pixarry(x,y,COLR)];
					ag = albedo[pixarry(x,y,COLG)];
					ab = albedo[pixarry(x,y,COLB)];
				} else {
					nx = normal[pixarry(x,y,AXISX)];
					ny = normal[pixarry(x,y,AXISY)];
					nz = normal[pixarry(x,y,AXISZ)];
					ar = albedo1[pixarry(x,y,COLR)];
					ag = albedo1[pixarry(x,y,COLG)];
					ab = albedo1[pixarry(x,y,COLB)];
				}
				shadingval = DOTPRODUCT(lightpos[j][AXISX], lightpos[j][AXISY], lightpos[j][AXISZ], nx, ny, nz);
				cost1 += (float)LORENTZ(NORM((double)shadingimage[imgarry(j,x,y,COLR)] - shadingval * ar,
					(double)shadingimage[imgarry(j,x,y,COLG)] - shadingval * ag,
					(double)shadingimage[imgarry(j,x,y,COLB)] - shadingval * ab));
			}
			cost1 /= (float)imagenum;
			cost1 *= LAMBDA;

			// f[^RXg̐ݒ
			graph->add_tweights(i, cost0, cost1);
		}
	}
	// E
	for(y = 0; y < HEIGHT; y++)
	{
		for(x = 0; x < WIDTH - 1; x++)
		{
			px = x;
			py = y;
			qx = x + 1;
			qy = y;
			i = py * WIDTH + px;
			j = qy * WIDTH + qx;

			if(mode == MIYA_NEEDLE) {
				p00 = normal0[pixarry(px,py,AXISX)];
				p01 = normal0[pixarry(px,py,AXISY)];
				p02 = normal0[pixarry(px,py,AXISZ)];
				p10 = normal1[pixarry(px,py,AXISX)];
				p11 = normal1[pixarry(px,py,AXISY)];
				p12 = normal1[pixarry(px,py,AXISZ)];
				q00 = normal0[pixarry(qx,qy,AXISX)];
				q01 = normal0[pixarry(qx,qy,AXISY)];
				q02 = normal0[pixarry(qx,qy,AXISZ)];
				q10 = normal1[pixarry(qx,qy,AXISX)];
				q11 = normal1[pixarry(qx,qy,AXISY)];
				q12 = normal1[pixarry(qx,qy,AXISZ)];
			} else {
				p00 = albedo0[pixarry(px,py,AXISX)];
				p01 = albedo0[pixarry(px,py,AXISY)];
				p02 = albedo0[pixarry(px,py,AXISZ)];
				p10 = albedo1[pixarry(px,py,AXISX)];
				p11 = albedo1[pixarry(px,py,AXISY)];
				p12 = albedo1[pixarry(px,py,AXISZ)];
				q00 = albedo0[pixarry(qx,qy,AXISX)];
				q01 = albedo0[pixarry(qx,qy,AXISY)];
				q02 = albedo0[pixarry(qx,qy,AXISZ)];
				q10 = albedo1[pixarry(qx,qy,AXISX)];
				q11 = albedo1[pixarry(qx,qy,AXISY)];
				q12 = albedo1[pixarry(qx,qy,AXISZ)];
			}

			// ̌0ƉĚ0̃RXg
			cost00 = (float)SQR(NORM(p00 - q00, p01 - q01, p02 - q02));

			// ̌1ƉĚ1̃RXg
			cost11 = (float)SQR(NORM(p10 - q10, p11 - q11, p12 - q12));

			// ̌0ƉĚ1̃RXg
			cost01 = (float)SQR(NORM(p00 - q10, p01 - q11, p02 - q12));

			// ̌1ƉĚ0̃RXg
			cost10 = (float)SQR(NORM(p10 - q00, p11 - q01, p12 - q02));

			// ^񒆂̃GbW
			costval = cost01 + cost10 - cost11 - cost00;
			if(costval < 0.0f) costval = 0.0f;
			graph->add_edge(i, j, costval, costval);

			// ̃\[XƃVN
			graph->add_tweights(i, cost00 + cost01, cost11 + cost10);

			// Ẽ\[XƃVN
			graph->add_tweights(j, cost00 + cost10, cost11 + cost01);
		}
	}
	// ㉺
	for(x = 0; x < WIDTH; x++)
	{
		for(y = 0; y < HEIGHT - 1; y++)
		{
			px = x;
			py = y;
			qx = x;
			qy = y + 1;
			i = py * WIDTH + px;
			j = qy * WIDTH + qx;

			if(mode == MIYA_NEEDLE) {
				p00 = normal0[pixarry(px,py,AXISX)];
				p01 = normal0[pixarry(px,py,AXISY)];
				p02 = normal0[pixarry(px,py,AXISZ)];
				p10 = normal1[pixarry(px,py,AXISX)];
				p11 = normal1[pixarry(px,py,AXISY)];
				p12 = normal1[pixarry(px,py,AXISZ)];
				q00 = normal0[pixarry(qx,qy,AXISX)];
				q01 = normal0[pixarry(qx,qy,AXISY)];
				q02 = normal0[pixarry(qx,qy,AXISZ)];
				q10 = normal1[pixarry(qx,qy,AXISX)];
				q11 = normal1[pixarry(qx,qy,AXISY)];
				q12 = normal1[pixarry(qx,qy,AXISZ)];
			} else {
				p00 = albedo0[pixarry(px,py,AXISX)];
				p01 = albedo0[pixarry(px,py,AXISY)];
				p02 = albedo0[pixarry(px,py,AXISZ)];
				p10 = albedo1[pixarry(px,py,AXISX)];
				p11 = albedo1[pixarry(px,py,AXISY)];
				p12 = albedo1[pixarry(px,py,AXISZ)];
				q00 = albedo0[pixarry(qx,qy,AXISX)];
				q01 = albedo0[pixarry(qx,qy,AXISY)];
				q02 = albedo0[pixarry(qx,qy,AXISZ)];
				q10 = albedo1[pixarry(qx,qy,AXISX)];
				q11 = albedo1[pixarry(qx,qy,AXISY)];
				q12 = albedo1[pixarry(qx,qy,AXISZ)];
			}

			// ̌0Ɖ̌0̃RXg
			cost00 = (float)SQR(NORM(p00 - q00, p01 - q01, p02 - q02));

			// ̌1Ɖ̌1̃RXg
			cost11 = (float)SQR(NORM(p10 - q10, p11 - q11, p12 - q12));

			// ̌0Ɖ̌1̃RXg
			cost01 = (float)SQR(NORM(p00 - q10, p01 - q11, p02 - q12));

			// ̌1Ɖ̌0̃RXg
			cost10 = (float)SQR(NORM(p10 - q00, p11 - q01, p12 - q02));

			// ^񒆂̃GbW
			costval = cost01 + cost10 - cost11 - cost00;
			if(costval < 0.0f) costval = 0.0f;
			graph->add_edge(i, j, costval, costval);

			// ̃\[XƃVN
			graph->add_tweights(i, cost00 + cost01, cost11 + cost10);

			// ̃\[XƃVN
			graph->add_tweights(j, cost00 + cost10, cost11 + cost01);
		}
	}

	// OtJbg
	graph -> maxflow();

	// RXgvZ
	flowcost = 0.0;
	// f[^RXg
	for(y = 0; y < HEIGHT; y++)
	{
		for(x = 0; x < WIDTH; x++)
		{
			costval = 0.0f;
			for(j = 0; j < imagenum; j++)
			{
				nx = normal[pixarry(x,y,AXISX)];
				ny = normal[pixarry(x,y,AXISY)];
				nz = normal[pixarry(x,y,AXISZ)];
				ar = albedo[pixarry(x,y,COLR)];
				ag = albedo[pixarry(x,y,COLG)];
				ab = albedo[pixarry(x,y,COLB)];
				shadingval = DOTPRODUCT(lightpos[j][AXISX], lightpos[j][AXISY], lightpos[j][AXISZ], nx, ny, nz);
				costval += (float)LORENTZ(NORM((double)shadingimage[imgarry(j,x,y,COLR)] - shadingval * ar,
					(double)shadingimage[imgarry(j,x,y,COLG)] - shadingval * ag,
					(double)shadingimage[imgarry(j,x,y,COLB)] - shadingval * ab));
			}
			costval /= (float)imagenum;
			costval *= LAMBDA;
			flowcost += (double)costval;
		}
	}
	// E
	for(y = 0; y < HEIGHT; y++)
	{
		for(x = 0; x < WIDTH - 1; x++)
		{
			px = x;
			py = y;
			qx = x + 1;
			qy = y;
			if(mode == MIYA_NEEDLE) {
				p0 = normal[pixarry(px,py,AXISX)];
				p1 = normal[pixarry(px,py,AXISY)];
				p2 = normal[pixarry(px,py,AXISZ)];
				q0 = normal[pixarry(qx,qy,AXISX)];
				q1 = normal[pixarry(qx,qy,AXISY)];
				q2 = normal[pixarry(qx,qy,AXISZ)];
			} else {
				p0 = albedo[pixarry(px,py,AXISX)];
				p1 = albedo[pixarry(px,py,AXISY)];
				p2 = albedo[pixarry(px,py,AXISZ)];
				q0 = albedo[pixarry(qx,qy,AXISX)];
				q1 = albedo[pixarry(qx,qy,AXISY)];
				q2 = albedo[pixarry(qx,qy,AXISZ)];
			}
			costval = (float)SQR(NORM(p0 - q0, p1 - q1, p2 - q2));
			flowcost += (double)costval;
		}
	}
	// ㉺
	for(x = 0; x < WIDTH; x++)
	{
		for(y = 0; y < HEIGHT - 1; y++)
		{
			px = x;
			py = y;
			qx = x;
			qy = y + 1;
			if(mode == MIYA_NEEDLE) {
				p0 = normal[pixarry(px,py,AXISX)];
				p1 = normal[pixarry(px,py,AXISY)];
				p2 = normal[pixarry(px,py,AXISZ)];
				q0 = normal[pixarry(qx,qy,AXISX)];
				q1 = normal[pixarry(qx,qy,AXISY)];
				q2 = normal[pixarry(qx,qy,AXISZ)];
			} else {
				p0 = albedo[pixarry(px,py,AXISX)];
				p1 = albedo[pixarry(px,py,AXISY)];
				p2 = albedo[pixarry(px,py,AXISZ)];
				q0 = albedo[pixarry(qx,qy,AXISX)];
				q1 = albedo[pixarry(qx,qy,AXISY)];
				q2 = albedo[pixarry(qx,qy,AXISZ)];
			}
			costval = (float)SQR(NORM(p0 - q0, p1 - q1, p2 - q2));
			flowcost += (double)costval;
		}
	}

	// ÕRXg
	if(mode == MIYA_NEEDLE) prevcost = flowcostneedle;
	else prevcost = flowcostalbedo;

	// x߂
	if(flowcost < prevcost) {
		for(y = 0; y < HEIGHT; y++)
		{
			for(x = 0; x < WIDTH; x++)
			{
				i = y * WIDTH + x;
				if(graph->what_segment(i) == GraphType::SOURCE) {
					// \[Xɑ遨VN؂Ă遨1̎}؂Ă遨1̃RXg1̗p
					if(mode == MIYA_NEEDLE) {
						normal[pixarry(x,y,AXISX)] = normal1[pixarry(x,y,AXISX)];
						normal[pixarry(x,y,AXISY)] = normal1[pixarry(x,y,AXISY)];
						normal[pixarry(x,y,AXISZ)] = normal1[pixarry(x,y,AXISZ)];
					} else {
						albedo[pixarry(x,y,COLR)] = albedo1[pixarry(x,y,COLR)];
						albedo[pixarry(x,y,COLG)] = albedo1[pixarry(x,y,COLG)];
						albedo[pixarry(x,y,COLB)] = albedo1[pixarry(x,y,COLB)];
					}
				} else {
					// VNɑ遨\[X؂Ă遨0̎}؂Ă遨0̃RXg0̗p
					if(mode == MIYA_NEEDLE) {
						normal[pixarry(x,y,AXISX)] = normal0[pixarry(x,y,AXISX)];
						normal[pixarry(x,y,AXISY)] = normal0[pixarry(x,y,AXISY)];
						normal[pixarry(x,y,AXISZ)] = normal0[pixarry(x,y,AXISZ)];
					} else {
						albedo[pixarry(x,y,COLR)] = albedo0[pixarry(x,y,COLR)];
						albedo[pixarry(x,y,COLG)] = albedo0[pixarry(x,y,COLG)];
						albedo[pixarry(x,y,COLB)] = albedo0[pixarry(x,y,COLB)];
					}
				}
			}
		}
		// RXgۑ
		if(mode == MIYA_NEEDLE) flowcostneedle = flowcost;
		else flowcostalbedo = flowcost;
	}
}
