#include "header.h"

/* إ٥׻ؿ */
LABEL *calcHierarchicalLabel(void)
{
  int NUM = NUM_OF_HIERARCHY;

  int i, j, k;

  /* ٥2߾ɽλؿ׻ */
  int index = 0;  
  for(i = 1; i < NUM; i *= 2) index++;

  /* إ٥Υ */
  LABEL *l;
  if((l = (LABEL *) malloc( 2 * index * sizeof(LABEL))) == NULL)
    {
      fprintf(stderr,"Malloc Error\n");
      return NULL;
    }

  /* إ٥η׻ */
  for(j = 0; j < index * 2; j++)
    {
      int tmpj = j / 2;

      /* Ƴؤǿη׻ */
      if(tmpj == 0)
	{
	  l[j].num = 1;
	}
      else
	{
	  l[j].num = mypow(2, tmpj - 1);
	}

      /* γ */
      if((l[j].label = (int *) malloc( l[j].num * sizeof(int) )) == NULL)
	{
	  fprintf(stderr,"Malloc Error, l[%d].label!!\n", j);
	  return NULL;
	}


      /* ٥η׻ */
      if(j == 0)
	{
	  l[j].label[0] = 0;
	}
      else if(j == 1)
	{
	  l[j].label[0] = NUM / 2;
	}
      else 
	{
	  int tmp = mypow(2, tmpj+1);

	  /* 2ʾζξ */
	  if(j % 2 == 0)
	    {
	      for(k = 0; k < l[j].num; k++)
		{
		  l[j].label[k] = (1 + (4 * k)) * NUM / tmp;
		}
	    }
	  /* 3ʾδξ */
	  else if(j % 2 == 1)
	    {
	      for(k = 0; k < l[j].num; k++)
		{
		  l[j].label[k] = (3 + (4 * k)) * NUM / tmp;
		}
	    }
	}      
    }

  return l;
}

/* إ٥Υؿ */
void FreeHierarchicalLabel(LABEL *l)
{
  int i;
  int index = 0;  

  for(i = 1; i < NUM_OF_HIERARCHY; i *= 2) index++;

  for(i = 0; i < index * 2; i++)
    {
      free(l[i].label);
    }
  free(l);
}

/* إ٥ɽؿ */
void printHierarchicalLabel(LABEL *l)
{
 int i, j, k;

  int index = 0;  
  for(i = 1; i < NUM_OF_HIERARCHY; i *= 2) index++;

  fprintf(stderr,"A =\t{\n");
  for(j = 0; j < 2 * index; j++)
    {
      fprintf(stderr,"\t{");
      for(k = 0; k < l[j].num; k++)
	{
	  fprintf(stderr,"%2d, ", l[j].label[k]);
	}
      fprintf(stderr,"\b\b},\n");
    }
  fprintf(stderr,"\t}\n");
}

/* إ٥˽ʣ٥롤­ʤ٥뤬̵åؿ */
int checkHierarchicalLabel(LABEL *l)
{
  int *checkflg;
  int i, j, k;

  if((checkflg = (int*) malloc(NUM_OF_HIERARCHY * sizeof(int))) == NULL)
    {
      fprintf(stderr,"Malloc Error\n");
      return -1;
    }

  for(i = 0; i < NUM_OF_HIERARCHY; i++) checkflg[i] = 0;

  int index = 0;  
  for(i = 1; i < NUM_OF_HIERARCHY; i *= 2) index++;

  for(j = 0; j < 2 * index; j++)
    {
      for(k = 0; k < l[j].num; k++)
	{
	  checkflg[l[j].label[k]]++;
	}
    }

  for(i = 0; i < NUM_OF_HIERARCHY; i++)
    {
      if(checkflg[i] == 1)
	{
	  continue;
	}
      else if(checkflg[i] == 0)
	{
	  fprintf(stderr,"Label [%d] is Nothing!!\n", i);

	  free(checkflg);
	  return -1;
	}
      else if(checkflg[i] > 1)
	{
	  fprintf(stderr,"There are lots of Label [%d]!!\n",i);

	  free(checkflg);
	  return -1;
	}
    }

  free(checkflg);
  return 1;
}




int mypow(int x, int n)
{
  return ((n == 0) ? 1 : (x * ( mypow(x, (n - 1)) )) );
}

