#include "header.h"

int judge(int x, int y, int width, int height)
{
  return (((x >= 0) && (x < width) && (y >= 0) && (y < height)) ? 1 : 0);
}

float calcDataCost(PGM *img1, PGM *img2, int x, int y, int disparity, int width, int height)
{
  switch(COST_TYPE)
    {
    case _SAD: 
      return SAD(img1, img2, x, y, disparity, width, height);
    case _SSD:
      return SSD(img1, img2, x, y, disparity, width, height);
    case _CORRELATION:
    default:
      fprintf(stderr,"Define Error COST_TYPE!! Check header.h.\n ");
      break;
    }
  return -1;
}


float SAD(PGM *img1, PGM *img2, int x, int y, int disparity, int width, int height)
{
  /**************************************************************/
  /*                                                            */
  /* SAD(d) = $B&2(B|I(x, y) - I(x - d, y)|                         */
  /*                                                            */
  /**************************************************************/

  float sum = 0.0;

  for(int v = -MASKSIZE; v <= MASKSIZE;  v++)
    {
      for(int u = -MASKSIZE; u <= MASKSIZE;  u++)
	{
	  /* $BJQ?t$N=i4|2=(B */
	  int lx = x + u;
	  int ly = y + v;

	  int rx = x + u - disparity;
	  int ry = y + v;

	  if((judge(lx, ly, width, height) == 1) && (judge(rx, ry, width, height) == 1))
	    {
	      /* $B2hA|Fb$G$"$l$P!$(BSAD$B$r7W;;(B */
	      sum += (float) abs(img1[lx + ly * width] - img2[rx + ry * width]);
	    }
	  else
	    {
	      /* $B2hA|$N30$J$i$P!$:GBg3,D4$rJV$9(B */
	      return -1;
	    }
	}
    }

  sum /= (float) sqr(2 * MASKSIZE + 1);
  return sum;
}

float SSD(PGM *img1, PGM *img2, int x, int y, int disparity, int width, int height)
{
  /**************************************************************/
  /*                                                            */
  /* SSD(d) = $B&2(B(I(x, y) - I(x - d, y))^2                       */
  /*                                                            */
  /**************************************************************/

  float sum = 0.0;

  for(int v = -MASKSIZE; v <= MASKSIZE;  v++)
    {
      for(int u = -MASKSIZE; u <= MASKSIZE;  u++)
	{
	  /* $BJQ?t$N=i4|2=(B */
	  int lx = x + u;
	  int ly = y + v;

	  int rx = x + u - disparity;
	  int ry = y + v;

	  if((judge(lx, ly, width, height) == 1) && (judge(rx, ry, width, height) == 1))
	    {
	      /* $B2hA|Fb$G$"$l$P!$(BSSD$B$r7W;;(B */
	      sum += (float) sqr(img1[lx + ly * width] - img2[rx + ry * width]);
	    }
	  else
	    {
	      /* $B2hA|$N30$J$i$P!$:GBg3,D4$N(B2$B>h$rJV$9(B */
	      return -1;
	    }
	}
    }

  sum /= (float) sqr(2 * MASKSIZE + 1);

  return sqrt(sum);
}



