#include "header.h"

float D(double fq, double lp)
{
  return (float) abs(fq - lp);
}

int V(int fp, int fq)
{
  return (C * abs(fp - fq));
}

int searchLabelNum(LABEL A, int beta)
{
  int alpha = NUM_OF_HIERARCHY;
  
  for(int k = 0; k < A.num; k++)
    {
      if(alpha > abs(beta -  A.label[k]))
	{
	  alpha = A.label[k];
	}
    }

  return alpha;
}


int* hierarchicalGraphCut(PGM *img1, PGM *img2, int width, int height,int maxval)
{
  /*
    D(rp) = |rp - Ip|
    $B=PNO2hA|(Brp$B$,F~NO2hA|(BIp$B$K=PMh$k$@$16a$/$J$k$h$&$K$9$k9`(B

    $B%9%`!<%:%3%9%H(B
    V(rp, rq) = c |rp - rq|
    $BNY$j9g$C$?2hAG$NL@$k$5(Brp$B$H(Brq$B$,$J$k$Y$/6a$/$J$k$h$&$K$9$k9`(B

    c $B$ODj?t$G==J,$@$,!$(B

    c = c0(exp(-d/c1)) c0, c1$BDj?t(B d=(Ip-Iq)^2($B%(%C%8$N6/$5(B)

    $B%i%Y%k!&!&!&(B      $BJQ?t!$%N%$%:=|5n$N>l9g$O!$(B0-255$B$N(B256$B<oN`(B
    $B8=:_$N%i%Y%k!&!&!&7+$jJV$77W;;$r9T$&!$H?I|%k!<%W$N8=;~E@$N>uBV(B
  */

  // $BJQ?t$N@k8@(B ($B%N!<%I?t(B $B$H(B $B%(%C%8?t(B)
  int nodenum = width * height + (width - 1) * height + width * (height - 1);
  int edgenum = (width - 1) * 2 * height + width * 2 * (height - 1);

  fprintf(stderr,"(NodeNum, EdgeNum) = (%5d, %5d)\n", nodenum, edgenum);

  int *beta;

  if((beta = (int*) malloc(width * height * sizeof(int))) == NULL){
    fprintf(stderr,"Malloc Erro beta!!\n");
    return NULL;
  }

 /* $B=i4|CM$N@_Dj(B */
  // for p = $BA4$F$N%T%/%;%k(B
  for(int i = 0; i < width * height; i++)
    {
      //      beta[i] = i % 64;
      beta[i] = 0;
    }
  // end for

  LABEL *A;     // $B3,AX%i%Y%k(B

  // $B3,AX%i%Y%k$N:n@.(B
  if((A = calcHierarchicalLabel()) == NULL)
    {
      fprintf(stderr,"Error in calcHierarchicalLabel!!\n");
      return NULL;
    }

  //  printHierarchicalLabel(A);

  int num = 0;
  for(int i = 1; i < NUM_OF_HIERARCHY; i = i * 2) num += 2;

  // E = $B$H$F$b$*$*$-$JCM(B
  int   Large    = 99999999;
  float E        = (float) Large;
  float infinity = 10000;

  // fprintf(stderr,"beta[%d] = %f, alpha = %f\n", j,beta[j],alpha);

  // for $B%k!<%W(B = 0 ~ $B$H$F$bBg$-$JCM(B
  for(int l = 0; l < Large; l++)
    {
      int success = 0;            // success = 0

      // $B3,AX$N?<$5$NJ,%k!<%W(B
      for(int i = 0; i < num; i++)
	{
	  // $B%0%i%U$N=i4|2=(B
	  GraphType *g = new GraphType(nodenum, edgenum);
	
	  // $BA4$F$N%N!<%IDI2C(B
	  g -> add_node(nodenum);
	  
	  // for p = $BA4$F$N%T%/%;%k(B
	  for(int v = 0; v < height; v++)
	    {
	      for(int u = 0; u < width; u++)
		{
		  // $B8=:_$N2hAG(B
		  int j = u + v * width;

		  // A[i]$B$N$&$A!$&B(Bp$B$K:G$b6a$$CM$r&A(Bp$B$K@_Dj(B
		  int alpha = searchLabelNum(A[i], beta[j]);

		  // $B%N!<%I$N(BSOURCE$BB&$K(BD($B&B(Bp)
		  float source = calcDataCost(img1, img2, u, v, beta[j], width, height);
		  if(source < 0) source = 1000;
		  // SINK$BB&$K(BD($B&A(Bp)$B$r@_Dj(B
		  float sink   = calcDataCost(img1, img2, u, v, alpha,   width, height);
		  if(sink < 0)  sink = 1000;
		  g -> add_tweights(j, source, sink);
		}
	    }
	  // end for
	
	  // for(p, q) = $BA4$F$NNY@\E@(B
	  int edgenum = width * height;
	  for(int v = 0; v < height; v++)
	    {
	      for(int u = 0; u < width; u++)
		{	  
		  
		  if(u < width - 1) // $B2hA|Fb$NHO0O$+H=Dj(B
		    {
		      // $B%N!<%I(Bp ($B8=:_$N2hAG(B)
		      int p = u     + v * width;

		      // $B%N!<%I(Bq ($B1&$N2hAG(B)
		      int q = u + 1 + v * width;

		      // A[i]$B$N$&$A!$&B(Bp$B$K:G$b6a$$CM$r&A(Bp$B$K@_Dj(B
		      int alpha_p =  searchLabelNum(A[i], beta[p]);

		      // A[i]$B$N$&$A!$&B(Bq$B$K:G$b6a$$CM$r&A(Bq$B$K@_Dj(B
		      int alpha_q =  searchLabelNum(A[i], beta[q]);
		    
		      // $B%N!<%I(Ba$B$N%=!<%9B&$K(BV(fp,fq),
		      float source = (float) V(beta[p], beta[q]);

		      // $B%7%s%/B&$K(BV(alpha, alpha)$B$r@_Dj(B
		      float sink   = (float) V(alpha_p, alpha_q);

		      g -> add_tweights(edgenum, source, sink);

		      // $B%N!<%I(Bp$B$H%N!<%I(Ba$B$N%(%C%8$N=E$_$K(BV(fp, alpha)
		    

		      // edgenum = $B%N!<%I(Ba
		      if(source <= sink)
			{
			  float e_pa = maximum(0, ((float) V(alpha_p, beta[q]) - source));
			  float e_ap = infinity;
			  float e_aq = infinity;
			  float e_qa = maximum(0, ((float) V(beta[p], alpha_q) - source));

			  /* $B%N!<%I(Bp$B$H%N!<%I(Ba$B$N%(%C%8$K=E$_$r@_Dj(B */
			  // p -- ( e_pa ) -> edgenum,  p <-- (e_ap) -- edgenum
			  g -> add_edge(p, edgenum, e_pa, e_ap);

			  // edgenum -- ( e_aq ) -> q, edgenum <-- (e_qa) -- q
			  g -> add_edge(edgenum, q, e_aq, e_qa);
			}

		      else
			{
			  float e_pa = infinity;
			  float e_ap = maximum(0, ((float) V(alpha_p, beta[q]) - sink));
			  float e_aq = maximum(0, ((float) V(beta[p], alpha_q) - sink));
			  float e_qa = infinity;

			  /* $B%N!<%I(Bp$B$H%N!<%I(Ba$B$N%(%C%8$K=E$_$r@_Dj(B */
			  // p -- ( e_pa ) -> edgenum,  p <-- (e_ap) -- edgenum
			  g -> add_edge(p, edgenum, e_pa, e_ap);

			  // edgenum -- ( e_aq ) -> q, edgenum <-- (e_qa) -- q
			  g -> add_edge(edgenum, q, e_aq, e_qa);
			}

		      edgenum++;
		    }

		  if(v < height - 1) // $B2hA|Fb$K$"$k$+H=Dj(B
		    {
		      // $B%N!<%I(Bp ($B8=:_$N2hAG(B)
		      int p = u +  v      * width;

		      // $B%N!<%I(Bq ($B2<$N2hAG(B)
		      int q = u + (v + 1) * width;

		      int alpha_p = searchLabelNum(A[i], beta[p]);
		      int alpha_q = searchLabelNum(A[i], beta[q]);
		    
		      // $B%N!<%I(Ba$B$N%=!<%9B&$K(BV(fp,fq),
		      float source = V(beta[p], beta[q]);

		      // SINK$BB&$K(BV(alpha, alpha)$B$r@_Dj(B
		      float sink   = V(alpha_p, alpha_q);

		      // $B%N!<%I(Ba$B$N%=!<%9$H%7%s%/$K=E$_$r@_Dj(B
		      g -> add_tweights(edgenum, source, sink);
		    
		      /* V($B&B(Bp, $B&B(Bq) <= V($B&A(Bp, $B&A(Bq) $B$N>l9g(B */
		      if(source <= sink)
			{
			  float e_pa = maximum(0, ((float) V(alpha_p, beta[q]) - source));
			  float e_ap = infinity;
			  float e_aq = infinity;
			  float e_qa = maximum(0, ((float) V(beta[p], alpha_q) - source));

			  /* $B%N!<%I(Bp$B$H%N!<%I(Ba$B$N%(%C%8$K=E$_$r@_Dj(B */
			  // p -- ( e_pa ) -> edgenum,  p <-- (e_ap) -- edgenum
			  g -> add_edge(p, edgenum, e_pa, e_ap);

			  // edgenum -- ( e_aq ) -> q, edgenum <-- (e_qa) -- q
			  g -> add_edge(edgenum, q, e_aq, e_qa);
			}

		      /* V($B&B(Bp, $B&B(Bq) >= V($B&A(Bp, $B&A(Bq) $B$N>l9g(B */
		      else if(source > sink)
			{
			  float e_pa = infinity;
			  float e_ap = maximum(0, ((float) V(alpha_p, beta[q]) - sink));
			  float e_aq = maximum(0, ((float) V(beta[p], alpha_q) - sink));
			  float e_qa = infinity;

			  /* $B%N!<%I(Bp$B$H%N!<%I(Ba$B$N%(%C%8$K(B($B=E$_(B)$B$r@_Dj(B */
			  // p -- ( e_pa ) -> edgenum,  p <-- (e_ap) -- edgenum
			  g -> add_edge(p, edgenum, e_pa, e_ap);

			  // edgenum -- ( e_aq ) -> q, edgenum <-- (e_qa) -- q
			  g -> add_edge(edgenum, q, e_aq, e_qa);
			}
		      edgenum++;
		    }
		}
	    }
	  // end for

	  // $B:GBgN.!&:G>.%+%C%H%"%k%4%j%:%`$NE,MQ(B

	  // Esum = $B5a$^$C$?%i%Y%k$G7W;;$7$?Am%3%9%H4X?t(B
	  float Esum = g -> maxflow();
	  // fprintf(stderr,"%2d:E = %f, Esum = %f\n", i, E, Esum);

	  // E'< E$B$J$i!$(B
	  if(Esum < E)
	    {
	      // $B8=:_$N%i%Y%k$r5a$^$C$?%i%Y%k$K$7!$(B
	      for(int j = 0; j < width * height; j++)
		{
		  if (g -> what_segment(j) == GraphType::SOURCE)
		    {
		      // A[i]$B$N$&$A!$&B(Bp$B$K:G$b6a$$CM$r&A(Bp$B$K@_Dj(B
		      beta[j] = searchLabelNum(A[i], beta[j]);
		    }
		}
	      // E = E'$B$K$7!$(B
	      E = Esum;
	      // success = 1$B$K$9$k!%(B
	      success = 1;
	    }
	  // $B%0%i%U$N>C5n(B
	  delete g;
	  //      fprintf(stdout,"%2d %f\n", i+l*num, E);
	}
      // end for

      // $B$b$7(B success = 0$B$J$i%k!<%W$rC&=P$9$k(B
      if(success == 0)
	{
	  break;
	}
    }
  // end for


  
#if 0 // $B2hA|$r(B0~256$B$NHO0O$KJQ99$9$k$J$i(B0$B$r(B1$B$K(B
  int max_disparity = 0;
  int min_disparity = 256;

  for(int i = 0; i < width * height; i++)
    {
      if(max_disparity < beta[i])
	{
	  max_disparity = beta[i];
	}

      if(min_disparity > beta[i])
	{
	  min_disparity = beta[i];
	}
    }

  fprintf(stderr,"Max Disparity = %d, Min Disparity = %d\n", max_disparity, min_disparity);

  for(int i = 0; i < width * height; i++)
    {
      beta[i] = (int) ((float) (beta[i] - min_disparity) * maxval / ((float) (max_disparity - min_disparity)));
    }
#endif

  FreeHierarchicalLabel(A);

  return beta;
}
