#include "header.h"

int checkExtend(char *filename);

int checkExtend(char *filename)
{
  char *ext[] = {".ppm", ".pgm", NULL};

  for(int i = 0; i < 2; i++)
    {
      if(strstr(filename, ext[i]) != NULL)
	{
	  return i;
	}
    }
      return -1;
}

int main(int argc, char **argv)
{
  PPM *color1, *color2;
  PGM *gray1, *gray2;

  int width1, height1, maxval1;
  int width2, height2, maxval2;

  /* $B%3%^%s%I%A%'%C%/(B */
  if(argc != 4){
    fprintf(stderr,"Usage: %s inputImage1 inputImage2 disparityImage\n", argv[0]);
    return -1;
  }

  /* $B2hA|$N3HD%;R$NFI$_9~$_(B */
  switch(checkExtend(argv[1]))
    {
    case 0:      /* $B%+%i!<2hA|(B(ppm)$B$J$iG;C82hA|$KJQ49(B */
      if((color1 = ReadPPM(argv[1], &width1, &height1, &maxval1)) == NULL)
	{
	  fprintf(stderr,"Error in ReadPPM!!\n");
	  return -1;
	}
      if((gray1 = PPMtoPGM(color1, width1, height1)) == NULL)
	{
	  fprintf(stderr,"Error in PPM to PGM!!\n");
	  return -1;
	}
      free(color1);
      break;

    case 1:      /* PGM$B2hA|FI$_9~$_(B */
      if((gray1 = ReadPGM(argv[1], &width1, &height1, &maxval1)) == NULL)
	{
	  fprintf(stderr,"Error in ReadFile!!\n");
	  return -1;
	}
      break;
    default:
      fprintf(stderr,"Image File Error\n");
      return -1;
    }

  switch(checkExtend(argv[2]))
    {
    case 0:      /* $B%+%i!<2hA|(B(ppm)$B$J$iG;C82hA|$KJQ49(B */
      if((color2 = ReadPPM(argv[2], &width2, &height2, &maxval2)) == NULL)
	{
	  fprintf(stderr,"Error in ReadPPM!!\n");
	  return -1;
	}
      if((gray2 = PPMtoPGM(color2, width2, height2)) == NULL)
	{
	  fprintf(stderr,"Error in PPM to PGM!!\n");
	  return -1;
	}
      free(color2);
      break;
    case 1:      /* PGM$B2hA|FI$_9~$_(B */
      if((gray2 = ReadPGM(argv[2], &width2, &height2, &maxval2)) == NULL)
	{
	  fprintf(stderr,"Error in ReadFile!!\n");
	  return -1;
	}
      break;
    default:
      fprintf(stderr,"Image File Error\n");
      return -1;
    }

  /* $B2hA|%5%$%:$,0c$C$?$i%(%i!<I=<((B */
  if(!((width1 == width2) && (height1 == height2) && (maxval1 == maxval2)))
    {
      fprintf(stderr,"Image Size is Different!!\n");
      fprintf(stderr,"Width  : 1) %3d, 2) %3d\n", width1,  width2);
      fprintf(stderr,"Height : 1) %3d, 2) %3d\n", height1, height2);
      fprintf(stderr,"Maxval : 1) %3d, 2) %3d\n", maxval1, maxval2);
      return -1;
    }



  /**********************************************************************/
  /* $B$3$3$+$i$,K\BN(B                                                     */
  /**********************************************************************/

  int *disparity;
  
  /* $B3,AX%0%i%U%+%C%H(B */
  if((disparity = hierarchicalGraphCut(gray1, gray2, width1, height1, maxval1)) == NULL)
    {
      fprintf(stderr,"Error in hierarchicalGraphCut!!\n");
      return -1;
    }

  /* PGM$B2hA|$N=PNO(B */
  if(WritePGM(argv[3], disparity, width1, height1, maxval1) < 0)
    {
      fprintf(stderr,"Save disparity Image\n");
      return -1;
    }

  /* $BNN0h3+J|(B */
  free(disparity);
  FreePGM(gray1);
  FreePGM(gray2);
  return 0;
}

