/************************************************************************/
/* File   : pnmread.cpp                                                 */
/* Writer : Takuya Shigetomi                                            */
/* Data   : 13, Nov, 2009                                               */
/************************************************************************/
#include "pnmread.h"

/*************************************************************/
/* $B2hA|MQ%a%b%j3NJ](B                                          */
/*************************************************************/
PPM* PPM_Init(int width, int height)
{
  PPM *img;
  int i;

  /* Malloc Error Check (*img)*/
  if((img = (PPM*) malloc(width * height * 3 * sizeof(PPM))) == NULL){
    fprintf(stderr,"Malloc Error\n");
    return NULL;
  }

  for(i = 0; i < width * height * 3; i++)    img[i] = 0;  

  return img;
}

PGM* PGM_Init(int width, int height)
{
  PGM *img;
  int i;
  /* Malloc Error Check (*img)*/
  if((img = (PGM*) malloc(width * height * sizeof(PGM))) == NULL){
    fprintf(stderr,"Malloc Error\n");
    return NULL;
  }

  for(i = 0; i < width * height; i++)    img[i] = 0;  

  return img;
}

/*************************************************************/
/* PNM$B$N%X%C%@$rFI$_9~$`4X?t(B                                 */
/*************************************************************/
int ReadPNMheader(FILE *fp, int *width, int *height, int *maxval)
{
  char magic[4];
  int FILETYPE;

  /* PNM$B%U%!%$%k$N%?%$%W(B(P3$B$H$+(BP4$B$H$+(B)$B$rFI$_9~$`(B */
  fgets(magic, 4, fp);
  
  if(magic[0] != 'P'){
    fprintf(stderr,"File Error, This Image is Not PNM File!!\n");
    return -1;
  }

  *width  = _getVal(fp);
  *height = _getVal(fp);
  *maxval = _getVal(fp);

  // fprintf(stderr,"width = %d, height = %d, maxval = %d\n", *width, *height, *maxval);
  /* $B%U%!%$%k$,%"%9%-!<$+%P%$%J%j$+%A%'%C%/(B */
  
  if(magic[1] >= '1' &&  magic[1] <= '3')
    {
      fprintf(stderr,"PNM file is Ascii\n");
      FILETYPE = ASCII_FILE;
    }
  else if(magic[1] >= '4' &&  magic[1] <= '6')
    {
      fprintf(stderr,"PNM file is binary\n");
      FILETYPE = BINARY_FILE;
    } 
  else
    {
      fprintf(stderr, "Header of This PNM File is not P(1 - 6)!!\n");
      return -1;
    }
  
  if(magic[1] == '1' ||  magic[1] == '4')
    {
      fprintf(stderr,"Sorry... This Program Can't Read PBM IMAGE!!\n");
      return -1;

      if(FILETYPE == BINARY_FILE) return PBM_BINARY;
      else return PBM_ASCII;
    }
  else if(magic[1] == '2' ||  magic[1] == '5')
    {
      if(FILETYPE == BINARY_FILE) return PGM_BINARY;
      else  return PGM_ASCII;
    }
  else if(magic[1] == '3' ||  magic[1] == '6')
    {
      if(FILETYPE == BINARY_FILE) return PPM_BINARY;
      else return PPM_ASCII;
    }
  
  return -1;
}

/*************************************************************/
/* ASCII$B7A<0$N2hA|$rFI$_9~$`4X?t(B                             */
/*************************************************************/
void ReadPPM_ASCII(FILE *fp, PPM *img, int width, int height)
{
  int i, j, k;

  for(i = 0; i < height; i++)
    for(j = 0; j < width; j++)
      for(k = 0; k < 3; k++)
	img[(j+i*width)*3+k] = _getVal(fp);

    fclose(fp);
}

void ReadPGM_ASCII(FILE *fp, PGM *img, int width, int height)
{
  int i, j;

  for(i = 0; i < height; i++)
    for(j = 0; j < width; j++)
      img[j+i*width] = _getVal(fp);
  
  fclose(fp);
}


/*********************************************************************/
/* $B2hA|>pJs$rFI$_9~$`4X?t(B                                            */
/*********************************************************************/
PGM* ReadPGM(char *filename, int *width, int *height, int *maxval)
{
  FILE *fp;
  PGM *img;

  int FILETYPE;
  int i, j, k;

  if((fp = fopen(filename, "r")) == NULL){
    fprintf(stderr,"File Open Error, %s\n", filename);
    fclose(fp);
    return NULL;
  }

  if((FILETYPE = ReadPNMheader(fp, width, height, maxval)) < 0){
    fprintf(stderr,"ReadPNMheader is Error\n");
    fclose(fp);
    return NULL;
  }

  if((img = PGM_Init(*width, *height)) == NULL){
    fprintf(stderr,"PGM_Init Error\n");
    fclose(fp);
    return NULL;
  }
      
  switch(FILETYPE)
    {
    case PGM_BINARY:
      fprintf(stderr,"Sorry..., This Program Can't Read Binary PNM\n");
      return NULL;
      
    case PGM_ASCII:
      ReadPGM_ASCII(fp, img, *width, *height);
      break;
      
    default:
      /* Do Nothing */
      return NULL;
    }
  
  return img;
}

PPM* ReadPPM(char *filename, int *width, int *height, int *maxval)
{
  FILE *fp;
  PPM *img;

  int FILETYPE;
  int i, j, k;

  if((fp = fopen(filename, "r")) == NULL){
    fprintf(stderr,"File Open Error, %s\n", filename);
    fclose(fp);
    return NULL;
  }

  if((FILETYPE = ReadPNMheader(fp, width, height, maxval)) < 0){
    fprintf(stderr,"ReadPPMheader is Error\n");
    fclose(fp);
    return NULL;
  }

  if((img = PPM_Init(*width, *height)) == NULL){
    fprintf(stderr,"Init Error\n");
    fclose(fp);
    return NULL;
  }
      
  switch(FILETYPE)
    {
    case PPM_BINARY:
      fprintf(stderr,"Sorry..., This Program Can't Read Binary PNM\n");
      return NULL;
      
    case PPM_ASCII:
      ReadPPM_ASCII(fp, img, *width, *height);
      break;
      
    default:
      /* Do Nothing */
      return NULL;
    }
  
  return img;
}


/********************************************************************/
/* $B2hA|>pJs$r=q$-9~$`4X?t(B                                           */
/********************************************************************/
int WritePGM(char *filename, PGM *img, int width, int height, int maxval)
{
  FILE *fp;
  int i, j;

  if((fp = fopen(filename, "w")) == NULL){
    fprintf(stderr,"File Open Error, %s\n", filename);
    return -1;
  }

  fprintf(fp, "P2\n%3d %3d\n%3d\n",width, height, maxval);
  for(i = 0; i < height; i++)
    for(j = 0; j < width; j++){
      fprintf(fp, "%3d ",  img[j+i*width]);
      if((j + i * width) % 20 == 19) fprintf(fp, "\n");
    }
  fclose(fp);

  return 1;
} 

int WritePPM(char *filename, PPM *img, int width, int height, int maxval)
{
  FILE *fp;
  int i, j, k;

  if((fp = fopen(filename, "w")) == NULL){
    fprintf(stderr,"File Open Error, %s\n", filename);
    return -1;
  }

  fprintf(fp, "P3\n%3d %3d\n%3d\n",width, height, maxval);
  for(i = 0; i < height; i++)
    for(j = 0; j < width; j++)
      for(k = 0; k < 3; k++){
	fprintf(fp, "%3d ", img[(j+i*width)*3+k]);
	if((((j + i * width) * 3 + k)  % 20) == 19) fprintf(fp, "\n");
      }
  fclose(fp);

  return 1;
} 

/**************************************************************/
/* Change PPM File to PGM File                                */
/**************************************************************/
PGM* PPMtoPGM(PPM *color, int width, int height)
{
  int i, j, k;
  double d[3] = {0.29891,0.58611,0.11448};

  PGM* gray;

  gray = (PGM*) malloc(width * height * sizeof(PGM));

  for(i = 0; i < height; i++)
    for(j = 0; j < width; j++){
      gray[j+i*width] = 0;
      for(k = 0; k < 3; k++)
	gray[j+i*width] += (int) ((double) color[(j+i*width)*3+k] * d[k]);
    }
  return gray;
}

/**************************************************************/
/* $B2hA|%a%b%j$N2rJ|(B                                           */
/**************************************************************/
int FreePGM(PGM *img)
{
  free(img);
  return 1;
}

int FreePPM(PPM *img)
{
  free(img);
  return 1;
}

/**********************************************************/
/* $B6uGr$r%9%-%C%W(B                                         */
/* $B%3%a%s%HJ8$b%9%-%C%W(B                                   */
/**********************************************************/
static void _skipSP(FILE *fp)
{
  int ch;
  
  while ((ch = fgetc(fp)) != EOF){

    /* $B6uGr$OL5;k(B */
    if (ch == ' ' || ch == '\t' || ch == '\n') continue;
    
    if (ch == '#'){
      /* $B%3%a%s%H$O9TKv$^$GFI$_Ht$P$9(B */
      while ((ch = fgetc(fp)) != EOF)
	{
	  if (ch == '\n')
	    {
	      break;
	    }
	}
      continue;
    }

    /* $BI,MW$J%G!<%?$rFI$s$G$7$^$C$?$N$GLa$9(B */
    ungetc(ch, fp);
    return;
  }
}

/**********************************************************/
/* $BCM$NFI$_9~$_(B                                           */
/**********************************************************/
static int _getVal(FILE *fp)
{
  int ch;
  int val = 0;
  
  _skipSP(fp);     /* $B6uGr$r%9%-%C%W(B */
  while((ch = fgetc(fp)) != EOF)
    {
      /* $B?tCM0J30$r8+$D$1$?$iH4$1$k(B */
      if (ch < '0' || ch > '9') break;
      
      /* $B0l7eA}$d$7$F?tCM$rDI2C(B */
      val = val * 10 + ch - '0';
    }
  
  _skipSP(fp);      /* $B6uGr$r%9%-%C%W(B */
  return(val);
}

