/************************************************************************/
/* File   : pnmread.h                                                   */
/* Writer : Takuya Shigetomi                                            */
/* Date   : 13, Nov, 2009                                                */
/************************************************************************/

/** include **/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define ASCII_FILE  1
#define BINARY_FILE 2

#define PBM_IMAGE   1
#define PGM_IMAGE   2  
#define PPM_IMAGE   3

#define PBM_ASCII    1
#define PGM_ASCII    2  
#define PPM_ASCII    3
#define PBM_BINARY   4
#define PGM_BINARY   5  
#define PPM_BINARY   6

typedef int           PPM;
typedef int           PGM;
typedef unsigned char uchar;
/** Prototype **/
PPM* PPM_Init(int width, int height);
PGM* PGM_Init(int width, int height);

int ReadPNMheader(FILE *fp, int *width, int *height, int *maxval);

void ReadPPM_ASCII(FILE *fp, PPM *img, int width, int height);
void ReadPGM_ASCII(FILE *fp, PGM *img, int width, int height);

PGM* ReadPGM(char *filename, int *width, int *height, int *maxval);
PPM* ReadPPM(char *filename, int *width, int *height, int *maxval);

int WritePGM(char *filename, PGM *img, int width, int height, int maxval);
int WritePPM(char *filename, PPM *img, int width, int height, int maxval);

PGM* PPMtoPGM(PPM *color, int width, int height);

int FreePPM(PPM *img);
int FreePGM(PGM *img);

static int _getVal(FILE *fp);
static void _skipSP(FILE *fp);
